package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  TagValue,
  TagKey,
  ApplicationName,
  ApplicationDescription
}
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    description: Optional[ApplicationDescription] = Optional.Absent,
    name: ApplicationName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.CreateApplicationRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          ApplicationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(ApplicationName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.CreateApplicationRequest.ReadOnly =
    zio.aws.mgn.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.CreateApplicationRequest =
      zio.aws.mgn.model.CreateApplicationRequest(
        description.map(value => value),
        name,
        tags.map(value => value)
      )
    def description: Optional[ApplicationDescription]
    def name: ApplicationName
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, ApplicationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ApplicationName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.CreateApplicationRequest
  ) extends zio.aws.mgn.model.CreateApplicationRequest.ReadOnly {
    override val description: Optional[ApplicationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mgn.model.primitives.ApplicationDescription(value)
        )
    override val name: ApplicationName =
      zio.aws.mgn.model.primitives.ApplicationName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.CreateApplicationRequest
  ): zio.aws.mgn.model.CreateApplicationRequest.ReadOnly = new Wrapper(impl)
}
