package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.ApplicationID
import scala.jdk.CollectionConverters._
final case class ArchiveApplicationRequest(applicationID: ApplicationID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest = {
    import ArchiveApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest
      .builder()
      .applicationID(ApplicationID.unwrap(applicationID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ArchiveApplicationRequest.ReadOnly =
    zio.aws.mgn.model.ArchiveApplicationRequest.wrap(buildAwsValue())
}
object ArchiveApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ArchiveApplicationRequest =
      zio.aws.mgn.model.ArchiveApplicationRequest(applicationID)
    def applicationID: ApplicationID
    def getApplicationID: ZIO[Any, Nothing, ApplicationID] =
      ZIO.succeed(applicationID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest
  ) extends zio.aws.mgn.model.ArchiveApplicationRequest.ReadOnly {
    override val applicationID: ApplicationID =
      zio.aws.mgn.model.primitives.ApplicationID(impl.applicationID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest
  ): zio.aws.mgn.model.ArchiveApplicationRequest.ReadOnly = new Wrapper(impl)
}
