package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.JmesPathString
import scala.jdk.CollectionConverters._
final case class SsmExternalParameter(
    dynamicPath: Optional[JmesPathString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.SsmExternalParameter = {
    import SsmExternalParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.SsmExternalParameter
      .builder()
      .optionallyWith(
        dynamicPath.map(value => JmesPathString.unwrap(value): java.lang.String)
      )(_.dynamicPath)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.SsmExternalParameter.ReadOnly =
    zio.aws.mgn.model.SsmExternalParameter.wrap(buildAwsValue())
}
object SsmExternalParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.SsmExternalParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.SsmExternalParameter =
      zio.aws.mgn.model.SsmExternalParameter(dynamicPath.map(value => value))
    def dynamicPath: Optional[JmesPathString]
    def getDynamicPath: ZIO[Any, AwsError, JmesPathString] =
      AwsError.unwrapOptionField("dynamicPath", dynamicPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.SsmExternalParameter
  ) extends zio.aws.mgn.model.SsmExternalParameter.ReadOnly {
    override val dynamicPath: Optional[JmesPathString] = zio.aws.core.internal
      .optionalFromNullable(impl.dynamicPath())
      .map(value => zio.aws.mgn.model.primitives.JmesPathString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.SsmExternalParameter
  ): zio.aws.mgn.model.SsmExternalParameter.ReadOnly = new Wrapper(impl)
}
