package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.WaveID
import scala.jdk.CollectionConverters._
final case class ListWavesRequestFilters(
    isArchived: Optional[Boolean] = Optional.Absent,
    waveIDs: Optional[Iterable[WaveID]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListWavesRequestFilters = {
    import ListWavesRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListWavesRequestFilters
      .builder()
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(
        waveIDs.map(value =>
          value.map { item =>
            WaveID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.waveIDs)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListWavesRequestFilters.ReadOnly =
    zio.aws.mgn.model.ListWavesRequestFilters.wrap(buildAwsValue())
}
object ListWavesRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListWavesRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListWavesRequestFilters =
      zio.aws.mgn.model.ListWavesRequestFilters(
        isArchived.map(value => value),
        waveIDs.map(value => value)
      )
    def isArchived: Optional[Boolean]
    def waveIDs: Optional[List[WaveID]]
    def getIsArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getWaveIDs: ZIO[Any, AwsError, List[WaveID]] =
      AwsError.unwrapOptionField("waveIDs", waveIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListWavesRequestFilters
  ) extends zio.aws.mgn.model.ListWavesRequestFilters.ReadOnly {
    override val isArchived: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArchived())
      .map(value => value: Boolean)
    override val waveIDs: Optional[List[WaveID]] = zio.aws.core.internal
      .optionalFromNullable(impl.waveIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.WaveID(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListWavesRequestFilters
  ): zio.aws.mgn.model.ListWavesRequestFilters.ReadOnly = new Wrapper(impl)
}
