package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListImportErrorsResponse(
    items: Optional[Iterable[zio.aws.mgn.model.ImportTaskError]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse = {
    import ListImportErrorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListImportErrorsResponse.ReadOnly =
    zio.aws.mgn.model.ListImportErrorsResponse.wrap(buildAwsValue())
}
object ListImportErrorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListImportErrorsResponse =
      zio.aws.mgn.model.ListImportErrorsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.mgn.model.ImportTaskError.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.ImportTaskError.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse
  ) extends zio.aws.mgn.model.ListImportErrorsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.mgn.model.ImportTaskError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.ImportTaskError.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse
  ): zio.aws.mgn.model.ListImportErrorsResponse.ReadOnly = new Wrapper(impl)
}
