package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{WaveID, ApplicationID}
import scala.jdk.CollectionConverters._
final case class ListApplicationsRequestFilters(
    applicationIDs: Optional[Iterable[ApplicationID]] = Optional.Absent,
    isArchived: Optional[Boolean] = Optional.Absent,
    waveIDs: Optional[Iterable[WaveID]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListApplicationsRequestFilters = {
    import ListApplicationsRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListApplicationsRequestFilters
      .builder()
      .optionallyWith(
        applicationIDs.map(value =>
          value.map { item =>
            ApplicationID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.applicationIDs)
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(
        waveIDs.map(value =>
          value.map { item =>
            WaveID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.waveIDs)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListApplicationsRequestFilters.ReadOnly =
    zio.aws.mgn.model.ListApplicationsRequestFilters.wrap(buildAwsValue())
}
object ListApplicationsRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListApplicationsRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListApplicationsRequestFilters =
      zio.aws.mgn.model.ListApplicationsRequestFilters(
        applicationIDs.map(value => value),
        isArchived.map(value => value),
        waveIDs.map(value => value)
      )
    def applicationIDs: Optional[List[ApplicationID]]
    def isArchived: Optional[Boolean]
    def waveIDs: Optional[List[WaveID]]
    def getApplicationIDs: ZIO[Any, AwsError, List[ApplicationID]] =
      AwsError.unwrapOptionField("applicationIDs", applicationIDs)
    def getIsArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getWaveIDs: ZIO[Any, AwsError, List[WaveID]] =
      AwsError.unwrapOptionField("waveIDs", waveIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListApplicationsRequestFilters
  ) extends zio.aws.mgn.model.ListApplicationsRequestFilters.ReadOnly {
    override val applicationIDs: Optional[List[ApplicationID]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationIDs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.primitives.ApplicationID(item)
          }.toList
        )
    override val isArchived: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArchived())
      .map(value => value: Boolean)
    override val waveIDs: Optional[List[WaveID]] = zio.aws.core.internal
      .optionalFromNullable(impl.waveIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.WaveID(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListApplicationsRequestFilters
  ): zio.aws.mgn.model.ListApplicationsRequestFilters.ReadOnly = new Wrapper(
    impl
  )
}
