package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  AccountID,
  ExportID,
  ISO8601DatetimeString,
  S3BucketName,
  S3Key
}
import scala.jdk.CollectionConverters._
final case class ExportTask(
    creationDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    endDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    exportID: Optional[ExportID] = Optional.Absent,
    progressPercentage: Optional[Float] = Optional.Absent,
    s3Bucket: Optional[S3BucketName] = Optional.Absent,
    s3BucketOwner: Optional[AccountID] = Optional.Absent,
    s3Key: Optional[S3Key] = Optional.Absent,
    status: Optional[zio.aws.mgn.model.ExportStatus] = Optional.Absent,
    summary: Optional[zio.aws.mgn.model.ExportTaskSummary] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.ExportTask = {
    import ExportTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ExportTask
      .builder()
      .optionallyWith(
        creationDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.creationDateTime)
      .optionallyWith(
        endDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.endDateTime)
      .optionallyWith(
        exportID.map(value => ExportID.unwrap(value): java.lang.String)
      )(_.exportID)
      .optionallyWith(progressPercentage.map(value => value: java.lang.Float))(
        _.progressPercentage
      )
      .optionallyWith(
        s3Bucket.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3BucketOwner.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.s3BucketOwner)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ExportTask.ReadOnly =
    zio.aws.mgn.model.ExportTask.wrap(buildAwsValue())
}
object ExportTask {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.ExportTask] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ExportTask = zio.aws.mgn.model.ExportTask(
      creationDateTime.map(value => value),
      endDateTime.map(value => value),
      exportID.map(value => value),
      progressPercentage.map(value => value),
      s3Bucket.map(value => value),
      s3BucketOwner.map(value => value),
      s3Key.map(value => value),
      status.map(value => value),
      summary.map(value => value.asEditable)
    )
    def creationDateTime: Optional[ISO8601DatetimeString]
    def endDateTime: Optional[ISO8601DatetimeString]
    def exportID: Optional[ExportID]
    def progressPercentage: Optional[Float]
    def s3Bucket: Optional[S3BucketName]
    def s3BucketOwner: Optional[AccountID]
    def s3Key: Optional[S3Key]
    def status: Optional[zio.aws.mgn.model.ExportStatus]
    def summary: Optional[zio.aws.mgn.model.ExportTaskSummary.ReadOnly]
    def getCreationDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getEndDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
    def getExportID: ZIO[Any, AwsError, ExportID] =
      AwsError.unwrapOptionField("exportID", exportID)
    def getProgressPercentage: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("progressPercentage", progressPercentage)
    def getS3Bucket: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3BucketOwner: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getStatus: ZIO[Any, AwsError, zio.aws.mgn.model.ExportStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSummary
        : ZIO[Any, AwsError, zio.aws.mgn.model.ExportTaskSummary.ReadOnly] =
      AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ExportTask
  ) extends zio.aws.mgn.model.ExportTask.ReadOnly {
    override val creationDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val endDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val exportID: Optional[ExportID] = zio.aws.core.internal
      .optionalFromNullable(impl.exportID())
      .map(value => zio.aws.mgn.model.primitives.ExportID(value))
    override val progressPercentage: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.progressPercentage())
      .map(value => value: Float)
    override val s3Bucket: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.mgn.model.primitives.S3BucketName(value))
    override val s3BucketOwner: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketOwner())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.mgn.model.primitives.S3Key(value))
    override val status: Optional[zio.aws.mgn.model.ExportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.mgn.model.ExportStatus.wrap(value))
    override val summary
        : Optional[zio.aws.mgn.model.ExportTaskSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summary())
        .map(value => zio.aws.mgn.model.ExportTaskSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ExportTask
  ): zio.aws.mgn.model.ExportTask.ReadOnly = new Wrapper(impl)
}
