package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait ExportStatus {
  def unwrap: software.amazon.awssdk.services.mgn.model.ExportStatus
}
object ExportStatus {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.ExportStatus
  ): zio.aws.mgn.model.ExportStatus = value match {
    case software.amazon.awssdk.services.mgn.model.ExportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.ExportStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.mgn.model.ExportStatus.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.mgn.model.ExportStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.mgn.model.ExportStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ExportStatus =
      software.amazon.awssdk.services.mgn.model.ExportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.mgn.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ExportStatus =
      software.amazon.awssdk.services.mgn.model.ExportStatus.PENDING
  }
  case object STARTED extends zio.aws.mgn.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ExportStatus =
      software.amazon.awssdk.services.mgn.model.ExportStatus.STARTED
  }
  case object FAILED extends zio.aws.mgn.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ExportStatus =
      software.amazon.awssdk.services.mgn.model.ExportStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.mgn.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ExportStatus =
      software.amazon.awssdk.services.mgn.model.ExportStatus.SUCCEEDED
  }
}
