package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.{WaveID, ApplicationID}
import scala.jdk.CollectionConverters._
final case class DisassociateApplicationsRequest(
    applicationIDs: Iterable[ApplicationID],
    waveID: WaveID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest = {
    import DisassociateApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest
      .builder()
      .applicationIDs(applicationIDs.map { item =>
        ApplicationID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .waveID(WaveID.unwrap(waveID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DisassociateApplicationsRequest.ReadOnly =
    zio.aws.mgn.model.DisassociateApplicationsRequest.wrap(buildAwsValue())
}
object DisassociateApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DisassociateApplicationsRequest =
      zio.aws.mgn.model.DisassociateApplicationsRequest(applicationIDs, waveID)
    def applicationIDs: List[ApplicationID]
    def waveID: WaveID
    def getApplicationIDs: ZIO[Any, Nothing, List[ApplicationID]] =
      ZIO.succeed(applicationIDs)
    def getWaveID: ZIO[Any, Nothing, WaveID] = ZIO.succeed(waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest
  ) extends zio.aws.mgn.model.DisassociateApplicationsRequest.ReadOnly {
    override val applicationIDs: List[ApplicationID] = impl
      .applicationIDs()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.ApplicationID(item)
      }
      .toList
    override val waveID: WaveID =
      zio.aws.mgn.model.primitives.WaveID(impl.waveID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest
  ): zio.aws.mgn.model.DisassociateApplicationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
