package zio.aws.mgn
import zio.aws.mgn.model.GetLaunchConfigurationResponse.ReadOnly
import software.amazon.awssdk.services.mgn.MgnAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.mgn.model.{
  DescribeReplicationConfigurationTemplatesRequest,
  UpdateApplicationRequest,
  CreateReplicationConfigurationTemplateRequest,
  DeleteVcenterClientRequest,
  DisconnectFromServiceRequest,
  UpdateSourceServerReplicationTypeRequest,
  DeleteApplicationRequest,
  FinalizeCutoverRequest,
  GetReplicationConfigurationRequest,
  CreateLaunchConfigurationTemplateRequest,
  ListImportErrorsRequest,
  ListSourceServerActionsRequest,
  ListImportsRequest,
  UnarchiveWaveRequest,
  DescribeLaunchConfigurationTemplatesRequest,
  StartExportRequest,
  UpdateLaunchConfigurationRequest,
  DeleteReplicationConfigurationTemplateRequest,
  CreateWaveRequest,
  StartReplicationRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  RetryDataReplicationRequest,
  ListExportsRequest,
  ListExportErrorsRequest,
  TerminateTargetInstancesRequest,
  DisassociateApplicationsRequest,
  DescribeJobsRequest,
  DisassociateSourceServersRequest,
  MarkAsArchivedRequest,
  RemoveSourceServerActionRequest,
  UpdateWaveRequest,
  DeleteJobRequest,
  DescribeSourceServersRequest,
  GetLaunchConfigurationRequest,
  RemoveTemplateActionRequest,
  UpdateLaunchConfigurationTemplateRequest,
  ArchiveWaveRequest,
  UpdateReplicationConfigurationRequest,
  DescribeJobLogItemsRequest,
  AssociateSourceServersRequest,
  PutSourceServerActionRequest,
  UntagResourceRequest,
  DeleteSourceServerRequest,
  ListApplicationsRequest,
  UnarchiveApplicationRequest,
  StartCutoverRequest,
  DeleteWaveRequest,
  DescribeVcenterClientsRequest,
  ChangeServerLifeCycleStateRequest,
  AssociateApplicationsRequest,
  ListTemplateActionsRequest,
  ListWavesRequest,
  ArchiveApplicationRequest,
  StartTestRequest,
  DeleteLaunchConfigurationTemplateRequest,
  UpdateReplicationConfigurationTemplateRequest,
  TagResourceRequest,
  PutTemplateActionRequest,
  StartImportRequest,
  InitializeServiceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object MgnMock extends Mock[Mgn] {
  object DeleteSourceServer
      extends Effect[
        DeleteSourceServerRequest,
        AwsError,
        zio.aws.mgn.model.DeleteSourceServerResponse.ReadOnly
      ]
  object UpdateWave
      extends Effect[
        UpdateWaveRequest,
        AwsError,
        zio.aws.mgn.model.UpdateWaveResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.mgn.model.DeleteApplicationResponse.ReadOnly
      ]
  object PutTemplateAction
      extends Effect[
        PutTemplateActionRequest,
        AwsError,
        zio.aws.mgn.model.PutTemplateActionResponse.ReadOnly
      ]
  object GetLaunchConfiguration
      extends Effect[GetLaunchConfigurationRequest, AwsError, ReadOnly]
  object UpdateReplicationConfigurationTemplate
      extends Effect[
        UpdateReplicationConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.UpdateReplicationConfigurationTemplateResponse.ReadOnly
      ]
  object StartExport
      extends Effect[
        StartExportRequest,
        AwsError,
        zio.aws.mgn.model.StartExportResponse.ReadOnly
      ]
  object TerminateTargetInstances
      extends Effect[
        TerminateTargetInstancesRequest,
        AwsError,
        zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly
      ]
  object MarkAsArchived
      extends Effect[
        MarkAsArchivedRequest,
        AwsError,
        zio.aws.mgn.model.MarkAsArchivedResponse.ReadOnly
      ]
  object AssociateApplications
      extends Effect[
        AssociateApplicationsRequest,
        AwsError,
        zio.aws.mgn.model.AssociateApplicationsResponse.ReadOnly
      ]
  object ListImports
      extends Stream[
        ListImportsRequest,
        AwsError,
        zio.aws.mgn.model.ImportTask.ReadOnly
      ]
  object ListImportsPaginated
      extends Effect[
        ListImportsRequest,
        AwsError,
        zio.aws.mgn.model.ListImportsResponse.ReadOnly
      ]
  object RemoveTemplateAction
      extends Effect[
        RemoveTemplateActionRequest,
        AwsError,
        zio.aws.mgn.model.RemoveTemplateActionResponse.ReadOnly
      ]
  object DescribeVcenterClients
      extends Stream[
        DescribeVcenterClientsRequest,
        AwsError,
        zio.aws.mgn.model.VcenterClient.ReadOnly
      ]
  object DescribeVcenterClientsPaginated
      extends Effect[
        DescribeVcenterClientsRequest,
        AwsError,
        zio.aws.mgn.model.DescribeVcenterClientsResponse.ReadOnly
      ]
  object StartImport
      extends Effect[
        StartImportRequest,
        AwsError,
        zio.aws.mgn.model.StartImportResponse.ReadOnly
      ]
  object DescribeReplicationConfigurationTemplates
      extends Stream[
        DescribeReplicationConfigurationTemplatesRequest,
        AwsError,
        zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly
      ]
  object DescribeReplicationConfigurationTemplatesPaginated
      extends Effect[
        DescribeReplicationConfigurationTemplatesRequest,
        AwsError,
        zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly
      ]
  object StartCutover
      extends Effect[
        StartCutoverRequest,
        AwsError,
        zio.aws.mgn.model.StartCutoverResponse.ReadOnly
      ]
  object InitializeService
      extends Effect[
        InitializeServiceRequest,
        AwsError,
        zio.aws.mgn.model.InitializeServiceResponse.ReadOnly
      ]
  object DisassociateSourceServers
      extends Effect[
        DisassociateSourceServersRequest,
        AwsError,
        zio.aws.mgn.model.DisassociateSourceServersResponse.ReadOnly
      ]
  object ListSourceServerActions
      extends Stream[
        ListSourceServerActionsRequest,
        AwsError,
        zio.aws.mgn.model.SourceServerActionDocument.ReadOnly
      ]
  object ListSourceServerActionsPaginated
      extends Effect[
        ListSourceServerActionsRequest,
        AwsError,
        zio.aws.mgn.model.ListSourceServerActionsResponse.ReadOnly
      ]
  object GetReplicationConfiguration
      extends Effect[
        GetReplicationConfigurationRequest,
        AwsError,
        zio.aws.mgn.model.GetReplicationConfigurationResponse.ReadOnly
      ]
  object UpdateLaunchConfigurationTemplate
      extends Effect[
        UpdateLaunchConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.UpdateLaunchConfigurationTemplateResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.mgn.model.CreateApplicationResponse.ReadOnly
      ]
  object StartReplication
      extends Effect[
        StartReplicationRequest,
        AwsError,
        zio.aws.mgn.model.StartReplicationResponse.ReadOnly
      ]
  object DescribeJobLogItems
      extends Stream[
        DescribeJobLogItemsRequest,
        AwsError,
        zio.aws.mgn.model.JobLog.ReadOnly
      ]
  object DescribeJobLogItemsPaginated
      extends Effect[
        DescribeJobLogItemsRequest,
        AwsError,
        zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly
      ]
  object UpdateSourceServerReplicationType
      extends Effect[
        UpdateSourceServerReplicationTypeRequest,
        AwsError,
        zio.aws.mgn.model.UpdateSourceServerReplicationTypeResponse.ReadOnly
      ]
  object DeleteVcenterClient
      extends Effect[DeleteVcenterClientRequest, AwsError, Unit]
  object ListExports
      extends Stream[
        ListExportsRequest,
        AwsError,
        zio.aws.mgn.model.ExportTask.ReadOnly
      ]
  object ListExportsPaginated
      extends Effect[
        ListExportsRequest,
        AwsError,
        zio.aws.mgn.model.ListExportsResponse.ReadOnly
      ]
  object UnarchiveApplication
      extends Effect[
        UnarchiveApplicationRequest,
        AwsError,
        zio.aws.mgn.model.UnarchiveApplicationResponse.ReadOnly
      ]
  object DisconnectFromService
      extends Effect[
        DisconnectFromServiceRequest,
        AwsError,
        zio.aws.mgn.model.DisconnectFromServiceResponse.ReadOnly
      ]
  object UnarchiveWave
      extends Effect[
        UnarchiveWaveRequest,
        AwsError,
        zio.aws.mgn.model.UnarchiveWaveResponse.ReadOnly
      ]
  object ListImportErrors
      extends Stream[
        ListImportErrorsRequest,
        AwsError,
        zio.aws.mgn.model.ImportTaskError.ReadOnly
      ]
  object ListImportErrorsPaginated
      extends Effect[
        ListImportErrorsRequest,
        AwsError,
        zio.aws.mgn.model.ListImportErrorsResponse.ReadOnly
      ]
  object DisassociateApplications
      extends Effect[
        DisassociateApplicationsRequest,
        AwsError,
        zio.aws.mgn.model.DisassociateApplicationsResponse.ReadOnly
      ]
  object DescribeJobs
      extends Stream[
        DescribeJobsRequest,
        AwsError,
        zio.aws.mgn.model.Job.ReadOnly
      ]
  object DescribeJobsPaginated
      extends Effect[
        DescribeJobsRequest,
        AwsError,
        zio.aws.mgn.model.DescribeJobsResponse.ReadOnly
      ]
  object CreateReplicationConfigurationTemplate
      extends Effect[
        CreateReplicationConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.CreateReplicationConfigurationTemplateResponse.ReadOnly
      ]
  object DeleteLaunchConfigurationTemplate
      extends Effect[
        DeleteLaunchConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.DeleteLaunchConfigurationTemplateResponse.ReadOnly
      ]
  object ArchiveApplication
      extends Effect[
        ArchiveApplicationRequest,
        AwsError,
        zio.aws.mgn.model.ArchiveApplicationResponse.ReadOnly
      ]
  object UpdateLaunchConfiguration
      extends Effect[
        UpdateLaunchConfigurationRequest,
        AwsError,
        zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly
      ]
  object DeleteWave
      extends Effect[
        DeleteWaveRequest,
        AwsError,
        zio.aws.mgn.model.DeleteWaveResponse.ReadOnly
      ]
  object ArchiveWave
      extends Effect[
        ArchiveWaveRequest,
        AwsError,
        zio.aws.mgn.model.ArchiveWaveResponse.ReadOnly
      ]
  object ListWaves
      extends Stream[
        ListWavesRequest,
        AwsError,
        zio.aws.mgn.model.Wave.ReadOnly
      ]
  object ListWavesPaginated
      extends Effect[
        ListWavesRequest,
        AwsError,
        zio.aws.mgn.model.ListWavesResponse.ReadOnly
      ]
  object UpdateReplicationConfiguration
      extends Effect[
        UpdateReplicationConfigurationRequest,
        AwsError,
        zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly
      ]
  object ListTemplateActions
      extends Stream[
        ListTemplateActionsRequest,
        AwsError,
        zio.aws.mgn.model.TemplateActionDocument.ReadOnly
      ]
  object ListTemplateActionsPaginated
      extends Effect[
        ListTemplateActionsRequest,
        AwsError,
        zio.aws.mgn.model.ListTemplateActionsResponse.ReadOnly
      ]
  object CreateWave
      extends Effect[
        CreateWaveRequest,
        AwsError,
        zio.aws.mgn.model.CreateWaveResponse.ReadOnly
      ]
  object DescribeSourceServers
      extends Stream[
        DescribeSourceServersRequest,
        AwsError,
        zio.aws.mgn.model.SourceServer.ReadOnly
      ]
  object DescribeSourceServersPaginated
      extends Effect[
        DescribeSourceServersRequest,
        AwsError,
        zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object PutSourceServerAction
      extends Effect[
        PutSourceServerActionRequest,
        AwsError,
        zio.aws.mgn.model.PutSourceServerActionResponse.ReadOnly
      ]
  object DeleteReplicationConfigurationTemplate
      extends Effect[
        DeleteReplicationConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.DeleteReplicationConfigurationTemplateResponse.ReadOnly
      ]
  object RemoveSourceServerAction
      extends Effect[
        RemoveSourceServerActionRequest,
        AwsError,
        zio.aws.mgn.model.RemoveSourceServerActionResponse.ReadOnly
      ]
  object ListExportErrors
      extends Stream[
        ListExportErrorsRequest,
        AwsError,
        zio.aws.mgn.model.ExportTaskError.ReadOnly
      ]
  object ListExportErrorsPaginated
      extends Effect[
        ListExportErrorsRequest,
        AwsError,
        zio.aws.mgn.model.ListExportErrorsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.mgn.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.mgn.model.Application.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.mgn.model.ListApplicationsResponse.ReadOnly
      ]
  object CreateLaunchConfigurationTemplate
      extends Effect[
        CreateLaunchConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.ReadOnly
      ]
  object FinalizeCutover
      extends Effect[
        FinalizeCutoverRequest,
        AwsError,
        zio.aws.mgn.model.FinalizeCutoverResponse.ReadOnly
      ]
  object DescribeLaunchConfigurationTemplates
      extends Stream[
        DescribeLaunchConfigurationTemplatesRequest,
        AwsError,
        zio.aws.mgn.model.LaunchConfigurationTemplate.ReadOnly
      ]
  object DescribeLaunchConfigurationTemplatesPaginated
      extends Effect[
        DescribeLaunchConfigurationTemplatesRequest,
        AwsError,
        zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.mgn.model.UpdateApplicationResponse.ReadOnly
      ]
  object RetryDataReplication
      extends Effect[
        RetryDataReplicationRequest,
        AwsError,
        zio.aws.mgn.model.RetryDataReplicationResponse.ReadOnly
      ]
  object ChangeServerLifeCycleState
      extends Effect[
        ChangeServerLifeCycleStateRequest,
        AwsError,
        zio.aws.mgn.model.ChangeServerLifeCycleStateResponse.ReadOnly
      ]
  object StartTest
      extends Effect[
        StartTestRequest,
        AwsError,
        zio.aws.mgn.model.StartTestResponse.ReadOnly
      ]
  object DeleteJob
      extends Effect[
        DeleteJobRequest,
        AwsError,
        zio.aws.mgn.model.DeleteJobResponse.ReadOnly
      ]
  object AssociateSourceServers
      extends Effect[
        AssociateSourceServersRequest,
        AwsError,
        zio.aws.mgn.model.AssociateSourceServersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Mgn] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Mgn] { rts =>
        zio.ZIO.succeed {
          new Mgn {
            val api: MgnAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Mgn = this
            def deleteSourceServer(request: DeleteSourceServerRequest): IO[
              AwsError,
              zio.aws.mgn.model.DeleteSourceServerResponse.ReadOnly
            ] = proxy(DeleteSourceServer, request)
            def updateWave(
                request: UpdateWaveRequest
            ): IO[AwsError, zio.aws.mgn.model.UpdateWaveResponse.ReadOnly] =
              proxy(UpdateWave, request)
            def deleteApplication(request: DeleteApplicationRequest): IO[
              AwsError,
              zio.aws.mgn.model.DeleteApplicationResponse.ReadOnly
            ] = proxy(DeleteApplication, request)
            def putTemplateAction(request: PutTemplateActionRequest): IO[
              AwsError,
              zio.aws.mgn.model.PutTemplateActionResponse.ReadOnly
            ] = proxy(PutTemplateAction, request)
            def getLaunchConfiguration(
                request: GetLaunchConfigurationRequest
            ): IO[AwsError, ReadOnly] = proxy(GetLaunchConfiguration, request)
            def updateReplicationConfigurationTemplate(
                request: UpdateReplicationConfigurationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.UpdateReplicationConfigurationTemplateResponse.ReadOnly
            ] = proxy(UpdateReplicationConfigurationTemplate, request)
            def startExport(
                request: StartExportRequest
            ): IO[AwsError, zio.aws.mgn.model.StartExportResponse.ReadOnly] =
              proxy(StartExport, request)
            def terminateTargetInstances(
                request: TerminateTargetInstancesRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly
            ] = proxy(TerminateTargetInstances, request)
            def markAsArchived(
                request: MarkAsArchivedRequest
            ): IO[AwsError, zio.aws.mgn.model.MarkAsArchivedResponse.ReadOnly] =
              proxy(MarkAsArchived, request)
            def associateApplications(
                request: AssociateApplicationsRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.AssociateApplicationsResponse.ReadOnly
            ] = proxy(AssociateApplications, request)
            def listImports(
                request: ListImportsRequest
            ): ZStream[Any, AwsError, zio.aws.mgn.model.ImportTask.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListImports, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listImportsPaginated(
                request: ListImportsRequest
            ): IO[AwsError, zio.aws.mgn.model.ListImportsResponse.ReadOnly] =
              proxy(ListImportsPaginated, request)
            def removeTemplateAction(request: RemoveTemplateActionRequest): IO[
              AwsError,
              zio.aws.mgn.model.RemoveTemplateActionResponse.ReadOnly
            ] = proxy(RemoveTemplateAction, request)
            def describeVcenterClients(
                request: DescribeVcenterClientsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.mgn.model.VcenterClient.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeVcenterClients, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeVcenterClientsPaginated(
                request: DescribeVcenterClientsRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DescribeVcenterClientsResponse.ReadOnly
            ] = proxy(DescribeVcenterClientsPaginated, request)
            def startImport(
                request: StartImportRequest
            ): IO[AwsError, zio.aws.mgn.model.StartImportResponse.ReadOnly] =
              proxy(StartImport, request)
            def describeReplicationConfigurationTemplates(
                request: DescribeReplicationConfigurationTemplatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeReplicationConfigurationTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeReplicationConfigurationTemplatesPaginated(
                request: DescribeReplicationConfigurationTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly
            ] =
              proxy(DescribeReplicationConfigurationTemplatesPaginated, request)
            def startCutover(
                request: StartCutoverRequest
            ): IO[AwsError, zio.aws.mgn.model.StartCutoverResponse.ReadOnly] =
              proxy(StartCutover, request)
            def initializeService(request: InitializeServiceRequest): IO[
              AwsError,
              zio.aws.mgn.model.InitializeServiceResponse.ReadOnly
            ] = proxy(InitializeService, request)
            def disassociateSourceServers(
                request: DisassociateSourceServersRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DisassociateSourceServersResponse.ReadOnly
            ] = proxy(DisassociateSourceServers, request)
            def listSourceServerActions(
                request: ListSourceServerActionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.mgn.model.SourceServerActionDocument.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSourceServerActions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSourceServerActionsPaginated(
                request: ListSourceServerActionsRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.ListSourceServerActionsResponse.ReadOnly
            ] = proxy(ListSourceServerActionsPaginated, request)
            def getReplicationConfiguration(
                request: GetReplicationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.GetReplicationConfigurationResponse.ReadOnly
            ] = proxy(GetReplicationConfiguration, request)
            def updateLaunchConfigurationTemplate(
                request: UpdateLaunchConfigurationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.UpdateLaunchConfigurationTemplateResponse.ReadOnly
            ] = proxy(UpdateLaunchConfigurationTemplate, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.mgn.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def startReplication(request: StartReplicationRequest): IO[
              AwsError,
              zio.aws.mgn.model.StartReplicationResponse.ReadOnly
            ] = proxy(StartReplication, request)
            def describeJobLogItems(
                request: DescribeJobLogItemsRequest
            ): ZStream[Any, AwsError, zio.aws.mgn.model.JobLog.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeJobLogItems, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeJobLogItemsPaginated(
                request: DescribeJobLogItemsRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly
            ] = proxy(DescribeJobLogItemsPaginated, request)
            def updateSourceServerReplicationType(
                request: UpdateSourceServerReplicationTypeRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.UpdateSourceServerReplicationTypeResponse.ReadOnly
            ] = proxy(UpdateSourceServerReplicationType, request)
            def deleteVcenterClient(
                request: DeleteVcenterClientRequest
            ): IO[AwsError, Unit] = proxy(DeleteVcenterClient, request)
            def listExports(
                request: ListExportsRequest
            ): ZStream[Any, AwsError, zio.aws.mgn.model.ExportTask.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListExports, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listExportsPaginated(
                request: ListExportsRequest
            ): IO[AwsError, zio.aws.mgn.model.ListExportsResponse.ReadOnly] =
              proxy(ListExportsPaginated, request)
            def unarchiveApplication(request: UnarchiveApplicationRequest): IO[
              AwsError,
              zio.aws.mgn.model.UnarchiveApplicationResponse.ReadOnly
            ] = proxy(UnarchiveApplication, request)
            def disconnectFromService(
                request: DisconnectFromServiceRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DisconnectFromServiceResponse.ReadOnly
            ] = proxy(DisconnectFromService, request)
            def unarchiveWave(
                request: UnarchiveWaveRequest
            ): IO[AwsError, zio.aws.mgn.model.UnarchiveWaveResponse.ReadOnly] =
              proxy(UnarchiveWave, request)
            def listImportErrors(request: ListImportErrorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.mgn.model.ImportTaskError.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImportErrors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImportErrorsPaginated(request: ListImportErrorsRequest): IO[
              AwsError,
              zio.aws.mgn.model.ListImportErrorsResponse.ReadOnly
            ] = proxy(ListImportErrorsPaginated, request)
            def disassociateApplications(
                request: DisassociateApplicationsRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DisassociateApplicationsResponse.ReadOnly
            ] = proxy(DisassociateApplications, request)
            def describeJobs(
                request: DescribeJobsRequest
            ): ZStream[Any, AwsError, zio.aws.mgn.model.Job.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeJobs, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeJobsPaginated(
                request: DescribeJobsRequest
            ): IO[AwsError, zio.aws.mgn.model.DescribeJobsResponse.ReadOnly] =
              proxy(DescribeJobsPaginated, request)
            def createReplicationConfigurationTemplate(
                request: CreateReplicationConfigurationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.CreateReplicationConfigurationTemplateResponse.ReadOnly
            ] = proxy(CreateReplicationConfigurationTemplate, request)
            def deleteLaunchConfigurationTemplate(
                request: DeleteLaunchConfigurationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DeleteLaunchConfigurationTemplateResponse.ReadOnly
            ] = proxy(DeleteLaunchConfigurationTemplate, request)
            def archiveApplication(request: ArchiveApplicationRequest): IO[
              AwsError,
              zio.aws.mgn.model.ArchiveApplicationResponse.ReadOnly
            ] = proxy(ArchiveApplication, request)
            def updateLaunchConfiguration(
                request: UpdateLaunchConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly
            ] = proxy(UpdateLaunchConfiguration, request)
            def deleteWave(
                request: DeleteWaveRequest
            ): IO[AwsError, zio.aws.mgn.model.DeleteWaveResponse.ReadOnly] =
              proxy(DeleteWave, request)
            def archiveWave(
                request: ArchiveWaveRequest
            ): IO[AwsError, zio.aws.mgn.model.ArchiveWaveResponse.ReadOnly] =
              proxy(ArchiveWave, request)
            def listWaves(
                request: ListWavesRequest
            ): ZStream[Any, AwsError, zio.aws.mgn.model.Wave.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListWaves, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listWavesPaginated(
                request: ListWavesRequest
            ): IO[AwsError, zio.aws.mgn.model.ListWavesResponse.ReadOnly] =
              proxy(ListWavesPaginated, request)
            def updateReplicationConfiguration(
                request: UpdateReplicationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly
            ] = proxy(UpdateReplicationConfiguration, request)
            def listTemplateActions(
                request: ListTemplateActionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.mgn.model.TemplateActionDocument.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTemplateActions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTemplateActionsPaginated(
                request: ListTemplateActionsRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.ListTemplateActionsResponse.ReadOnly
            ] = proxy(ListTemplateActionsPaginated, request)
            def createWave(
                request: CreateWaveRequest
            ): IO[AwsError, zio.aws.mgn.model.CreateWaveResponse.ReadOnly] =
              proxy(CreateWave, request)
            def describeSourceServers(
                request: DescribeSourceServersRequest
            ): ZStream[Any, AwsError, zio.aws.mgn.model.SourceServer.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeSourceServers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeSourceServersPaginated(
                request: DescribeSourceServersRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly
            ] = proxy(DescribeSourceServersPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def putSourceServerAction(
                request: PutSourceServerActionRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.PutSourceServerActionResponse.ReadOnly
            ] = proxy(PutSourceServerAction, request)
            def deleteReplicationConfigurationTemplate(
                request: DeleteReplicationConfigurationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DeleteReplicationConfigurationTemplateResponse.ReadOnly
            ] = proxy(DeleteReplicationConfigurationTemplate, request)
            def removeSourceServerAction(
                request: RemoveSourceServerActionRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.RemoveSourceServerActionResponse.ReadOnly
            ] = proxy(RemoveSourceServerAction, request)
            def listExportErrors(request: ListExportErrorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.mgn.model.ExportTaskError.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListExportErrors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listExportErrorsPaginated(request: ListExportErrorsRequest): IO[
              AwsError,
              zio.aws.mgn.model.ListExportErrorsResponse.ReadOnly
            ] = proxy(ListExportErrorsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.mgn.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def listApplications(
                request: ListApplicationsRequest
            ): ZStream[Any, AwsError, zio.aws.mgn.model.Application.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListApplications, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.mgn.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def createLaunchConfigurationTemplate(
                request: CreateLaunchConfigurationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.ReadOnly
            ] = proxy(CreateLaunchConfigurationTemplate, request)
            def finalizeCutover(request: FinalizeCutoverRequest): IO[
              AwsError,
              zio.aws.mgn.model.FinalizeCutoverResponse.ReadOnly
            ] = proxy(FinalizeCutover, request)
            def describeLaunchConfigurationTemplates(
                request: DescribeLaunchConfigurationTemplatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.mgn.model.LaunchConfigurationTemplate.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeLaunchConfigurationTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeLaunchConfigurationTemplatesPaginated(
                request: DescribeLaunchConfigurationTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesResponse.ReadOnly
            ] = proxy(DescribeLaunchConfigurationTemplatesPaginated, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.mgn.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
            def retryDataReplication(request: RetryDataReplicationRequest): IO[
              AwsError,
              zio.aws.mgn.model.RetryDataReplicationResponse.ReadOnly
            ] = proxy(RetryDataReplication, request)
            def changeServerLifeCycleState(
                request: ChangeServerLifeCycleStateRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.ChangeServerLifeCycleStateResponse.ReadOnly
            ] = proxy(ChangeServerLifeCycleState, request)
            def startTest(
                request: StartTestRequest
            ): IO[AwsError, zio.aws.mgn.model.StartTestResponse.ReadOnly] =
              proxy(StartTest, request)
            def deleteJob(
                request: DeleteJobRequest
            ): IO[AwsError, zio.aws.mgn.model.DeleteJobResponse.ReadOnly] =
              proxy(DeleteJob, request)
            def associateSourceServers(
                request: AssociateSourceServersRequest
            ): IO[
              AwsError,
              zio.aws.mgn.model.AssociateSourceServersResponse.ReadOnly
            ] = proxy(AssociateSourceServers, request)
          }
        }
      }
    }
  }
}
