package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  WaveName,
  TagValue,
  ISO8601DatetimeString,
  WaveID,
  WaveDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class UpdateWaveResponse(
    arn: Optional[ARN] = Optional.Absent,
    creationDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    description: Optional[WaveDescription] = Optional.Absent,
    isArchived: Optional[Boolean] = Optional.Absent,
    lastModifiedDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    name: Optional[WaveName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    waveAggregatedStatus: Optional[zio.aws.mgn.model.WaveAggregatedStatus] =
      Optional.Absent,
    waveID: Optional[WaveID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateWaveResponse = {
    import UpdateWaveResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateWaveResponse
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        creationDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.creationDateTime)
      .optionallyWith(
        description.map(value =>
          WaveDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(
        lastModifiedDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.lastModifiedDateTime)
      .optionallyWith(
        name.map(value => WaveName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(waveAggregatedStatus.map(value => value.buildAwsValue()))(
        _.waveAggregatedStatus
      )
      .optionallyWith(
        waveID.map(value => WaveID.unwrap(value): java.lang.String)
      )(_.waveID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UpdateWaveResponse.ReadOnly =
    zio.aws.mgn.model.UpdateWaveResponse.wrap(buildAwsValue())
}
object UpdateWaveResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateWaveResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateWaveResponse =
      zio.aws.mgn.model.UpdateWaveResponse(
        arn.map(value => value),
        creationDateTime.map(value => value),
        description.map(value => value),
        isArchived.map(value => value),
        lastModifiedDateTime.map(value => value),
        name.map(value => value),
        tags.map(value => value),
        waveAggregatedStatus.map(value => value.asEditable),
        waveID.map(value => value)
      )
    def arn: Optional[ARN]
    def creationDateTime: Optional[ISO8601DatetimeString]
    def description: Optional[WaveDescription]
    def isArchived: Optional[Boolean]
    def lastModifiedDateTime: Optional[ISO8601DatetimeString]
    def name: Optional[WaveName]
    def tags: Optional[Map[TagKey, TagValue]]
    def waveAggregatedStatus
        : Optional[zio.aws.mgn.model.WaveAggregatedStatus.ReadOnly]
    def waveID: Optional[WaveID]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getCreationDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getDescription: ZIO[Any, AwsError, WaveDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIsArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLastModifiedDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("lastModifiedDateTime", lastModifiedDateTime)
    def getName: ZIO[Any, AwsError, WaveName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWaveAggregatedStatus
        : ZIO[Any, AwsError, zio.aws.mgn.model.WaveAggregatedStatus.ReadOnly] =
      AwsError.unwrapOptionField("waveAggregatedStatus", waveAggregatedStatus)
    def getWaveID: ZIO[Any, AwsError, WaveID] =
      AwsError.unwrapOptionField("waveID", waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateWaveResponse
  ) extends zio.aws.mgn.model.UpdateWaveResponse.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val creationDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val description: Optional[WaveDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.mgn.model.primitives.WaveDescription(value))
    override val isArchived: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArchived())
      .map(value => value: Boolean)
    override val lastModifiedDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val name: Optional[WaveName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.WaveName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val waveAggregatedStatus
        : Optional[zio.aws.mgn.model.WaveAggregatedStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.waveAggregatedStatus())
        .map(value => zio.aws.mgn.model.WaveAggregatedStatus.wrap(value))
    override val waveID: Optional[WaveID] = zio.aws.core.internal
      .optionalFromNullable(impl.waveID())
      .map(value => zio.aws.mgn.model.primitives.WaveID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateWaveResponse
  ): zio.aws.mgn.model.UpdateWaveResponse.ReadOnly = new Wrapper(impl)
}
