package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.mgn.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.JobStatus
  ): zio.aws.mgn.model.JobStatus = value match {
    case software.amazon.awssdk.services.mgn.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.JobStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.mgn.model.JobStatus.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.mgn.model.JobStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobStatus =
      software.amazon.awssdk.services.mgn.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.mgn.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobStatus =
      software.amazon.awssdk.services.mgn.model.JobStatus.PENDING
  }
  case object STARTED extends zio.aws.mgn.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobStatus =
      software.amazon.awssdk.services.mgn.model.JobStatus.STARTED
  }
  case object COMPLETED extends zio.aws.mgn.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobStatus =
      software.amazon.awssdk.services.mgn.model.JobStatus.COMPLETED
  }
}
