package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  EC2LaunchConfigurationTemplateID,
  PositiveInteger,
  TagValue,
  LaunchConfigurationTemplateID,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateLaunchConfigurationTemplateResponse(
    arn: Optional[ARN] = Optional.Absent,
    associatePublicIpAddress: Optional[Boolean] = Optional.Absent,
    bootMode: Optional[zio.aws.mgn.model.BootMode] = Optional.Absent,
    copyPrivateIp: Optional[Boolean] = Optional.Absent,
    copyTags: Optional[Boolean] = Optional.Absent,
    ec2LaunchTemplateID: Optional[EC2LaunchConfigurationTemplateID] =
      Optional.Absent,
    enableMapAutoTagging: Optional[Boolean] = Optional.Absent,
    largeVolumeConf: Optional[zio.aws.mgn.model.LaunchTemplateDiskConf] =
      Optional.Absent,
    launchConfigurationTemplateID: LaunchConfigurationTemplateID,
    launchDisposition: Optional[zio.aws.mgn.model.LaunchDisposition] =
      Optional.Absent,
    licensing: Optional[zio.aws.mgn.model.Licensing] = Optional.Absent,
    mapAutoTaggingMpeID: Optional[TagValue] = Optional.Absent,
    postLaunchActions: Optional[zio.aws.mgn.model.PostLaunchActions] =
      Optional.Absent,
    smallVolumeConf: Optional[zio.aws.mgn.model.LaunchTemplateDiskConf] =
      Optional.Absent,
    smallVolumeMaxSize: Optional[PositiveInteger] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    targetInstanceTypeRightSizingMethod: Optional[
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse = {
    import CreateLaunchConfigurationTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(copyPrivateIp.map(value => value: java.lang.Boolean))(
        _.copyPrivateIp
      )
      .optionallyWith(copyTags.map(value => value: java.lang.Boolean))(
        _.copyTags
      )
      .optionallyWith(
        ec2LaunchTemplateID.map(value =>
          EC2LaunchConfigurationTemplateID.unwrap(value): java.lang.String
        )
      )(_.ec2LaunchTemplateID)
      .optionallyWith(
        enableMapAutoTagging.map(value => value: java.lang.Boolean)
      )(_.enableMapAutoTagging)
      .optionallyWith(largeVolumeConf.map(value => value.buildAwsValue()))(
        _.largeVolumeConf
      )
      .launchConfigurationTemplateID(
        LaunchConfigurationTemplateID.unwrap(
          launchConfigurationTemplateID
        ): java.lang.String
      )
      .optionallyWith(launchDisposition.map(value => value.unwrap))(
        _.launchDisposition
      )
      .optionallyWith(licensing.map(value => value.buildAwsValue()))(
        _.licensing
      )
      .optionallyWith(
        mapAutoTaggingMpeID.map(value =>
          TagValue.unwrap(value): java.lang.String
        )
      )(_.mapAutoTaggingMpeID)
      .optionallyWith(postLaunchActions.map(value => value.buildAwsValue()))(
        _.postLaunchActions
      )
      .optionallyWith(smallVolumeConf.map(value => value.buildAwsValue()))(
        _.smallVolumeConf
      )
      .optionallyWith(
        smallVolumeMaxSize.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.smallVolumeMaxSize)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        targetInstanceTypeRightSizingMethod.map(value => value.unwrap)
      )(_.targetInstanceTypeRightSizingMethod)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.ReadOnly =
    zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse
      .wrap(buildAwsValue())
}
object CreateLaunchConfigurationTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse =
      zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse(
        arn.map(value => value),
        associatePublicIpAddress.map(value => value),
        bootMode.map(value => value),
        copyPrivateIp.map(value => value),
        copyTags.map(value => value),
        ec2LaunchTemplateID.map(value => value),
        enableMapAutoTagging.map(value => value),
        largeVolumeConf.map(value => value.asEditable),
        launchConfigurationTemplateID,
        launchDisposition.map(value => value),
        licensing.map(value => value.asEditable),
        mapAutoTaggingMpeID.map(value => value),
        postLaunchActions.map(value => value.asEditable),
        smallVolumeConf.map(value => value.asEditable),
        smallVolumeMaxSize.map(value => value),
        tags.map(value => value),
        targetInstanceTypeRightSizingMethod.map(value => value)
      )
    def arn: Optional[ARN]
    def associatePublicIpAddress: Optional[Boolean]
    def bootMode: Optional[zio.aws.mgn.model.BootMode]
    def copyPrivateIp: Optional[Boolean]
    def copyTags: Optional[Boolean]
    def ec2LaunchTemplateID: Optional[EC2LaunchConfigurationTemplateID]
    def enableMapAutoTagging: Optional[Boolean]
    def largeVolumeConf
        : Optional[zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly]
    def launchConfigurationTemplateID: LaunchConfigurationTemplateID
    def launchDisposition: Optional[zio.aws.mgn.model.LaunchDisposition]
    def licensing: Optional[zio.aws.mgn.model.Licensing.ReadOnly]
    def mapAutoTaggingMpeID: Optional[TagValue]
    def postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly]
    def smallVolumeConf
        : Optional[zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly]
    def smallVolumeMaxSize: Optional[PositiveInteger]
    def tags: Optional[Map[TagKey, TagValue]]
    def targetInstanceTypeRightSizingMethod
        : Optional[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getBootMode: ZIO[Any, AwsError, zio.aws.mgn.model.BootMode] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getCopyPrivateIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyPrivateIp", copyPrivateIp)
    def getCopyTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getEc2LaunchTemplateID
        : ZIO[Any, AwsError, EC2LaunchConfigurationTemplateID] =
      AwsError.unwrapOptionField("ec2LaunchTemplateID", ec2LaunchTemplateID)
    def getEnableMapAutoTagging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableMapAutoTagging", enableMapAutoTagging)
    def getLargeVolumeConf: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly
    ] = AwsError.unwrapOptionField("largeVolumeConf", largeVolumeConf)
    def getLaunchConfigurationTemplateID
        : ZIO[Any, Nothing, LaunchConfigurationTemplateID] =
      ZIO.succeed(launchConfigurationTemplateID)
    def getLaunchDisposition
        : ZIO[Any, AwsError, zio.aws.mgn.model.LaunchDisposition] =
      AwsError.unwrapOptionField("launchDisposition", launchDisposition)
    def getLicensing: ZIO[Any, AwsError, zio.aws.mgn.model.Licensing.ReadOnly] =
      AwsError.unwrapOptionField("licensing", licensing)
    def getMapAutoTaggingMpeID: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("mapAutoTaggingMpeID", mapAutoTaggingMpeID)
    def getPostLaunchActions
        : ZIO[Any, AwsError, zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      AwsError.unwrapOptionField("postLaunchActions", postLaunchActions)
    def getSmallVolumeConf: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly
    ] = AwsError.unwrapOptionField("smallVolumeConf", smallVolumeConf)
    def getSmallVolumeMaxSize: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("smallVolumeMaxSize", smallVolumeMaxSize)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTargetInstanceTypeRightSizingMethod: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = AwsError.unwrapOptionField(
      "targetInstanceTypeRightSizingMethod",
      targetInstanceTypeRightSizingMethod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse
  ) extends zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val associatePublicIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatePublicIpAddress())
        .map(value => value: Boolean)
    override val bootMode: Optional[zio.aws.mgn.model.BootMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.mgn.model.BootMode.wrap(value))
    override val copyPrivateIp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyPrivateIp())
      .map(value => value: Boolean)
    override val copyTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTags())
      .map(value => value: Boolean)
    override val ec2LaunchTemplateID
        : Optional[EC2LaunchConfigurationTemplateID] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2LaunchTemplateID())
      .map(value =>
        zio.aws.mgn.model.primitives.EC2LaunchConfigurationTemplateID(value)
      )
    override val enableMapAutoTagging: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableMapAutoTagging())
      .map(value => value: Boolean)
    override val largeVolumeConf
        : Optional[zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.largeVolumeConf())
        .map(value => zio.aws.mgn.model.LaunchTemplateDiskConf.wrap(value))
    override val launchConfigurationTemplateID: LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives
        .LaunchConfigurationTemplateID(impl.launchConfigurationTemplateID())
    override val launchDisposition
        : Optional[zio.aws.mgn.model.LaunchDisposition] = zio.aws.core.internal
      .optionalFromNullable(impl.launchDisposition())
      .map(value => zio.aws.mgn.model.LaunchDisposition.wrap(value))
    override val licensing: Optional[zio.aws.mgn.model.Licensing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licensing())
        .map(value => zio.aws.mgn.model.Licensing.wrap(value))
    override val mapAutoTaggingMpeID: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.mapAutoTaggingMpeID())
      .map(value => zio.aws.mgn.model.primitives.TagValue(value))
    override val postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postLaunchActions())
        .map(value => zio.aws.mgn.model.PostLaunchActions.wrap(value))
    override val smallVolumeConf
        : Optional[zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smallVolumeConf())
        .map(value => zio.aws.mgn.model.LaunchTemplateDiskConf.wrap(value))
    override val smallVolumeMaxSize: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smallVolumeMaxSize())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val targetInstanceTypeRightSizingMethod
        : Optional[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetInstanceTypeRightSizingMethod())
        .map(value =>
          zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse
  ): zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
