package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{JobID, ISO8601DatetimeString}
import scala.jdk.CollectionConverters._
final case class LifeCycleLastTestInitiated(
    apiCallDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    jobID: Optional[JobID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LifeCycleLastTestInitiated = {
    import LifeCycleLastTestInitiated.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycleLastTestInitiated
      .builder()
      .optionallyWith(
        apiCallDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.apiCallDateTime)
      .optionallyWith(
        jobID.map(value => JobID.unwrap(value): java.lang.String)
      )(_.jobID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycleLastTestInitiated.ReadOnly =
    zio.aws.mgn.model.LifeCycleLastTestInitiated.wrap(buildAwsValue())
}
object LifeCycleLastTestInitiated {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LifeCycleLastTestInitiated
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycleLastTestInitiated =
      zio.aws.mgn.model.LifeCycleLastTestInitiated(
        apiCallDateTime.map(value => value),
        jobID.map(value => value)
      )
    def apiCallDateTime: Optional[ISO8601DatetimeString]
    def jobID: Optional[JobID]
    def getApiCallDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("apiCallDateTime", apiCallDateTime)
    def getJobID: ZIO[Any, AwsError, JobID] =
      AwsError.unwrapOptionField("jobID", jobID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastTestInitiated
  ) extends zio.aws.mgn.model.LifeCycleLastTestInitiated.ReadOnly {
    override val apiCallDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCallDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val jobID: Optional[JobID] = zio.aws.core.internal
      .optionalFromNullable(impl.jobID())
      .map(value => zio.aws.mgn.model.primitives.JobID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastTestInitiated
  ): zio.aws.mgn.model.LifeCycleLastTestInitiated.ReadOnly = new Wrapper(impl)
}
