package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  PaginationToken,
  MaxResultsType,
  LaunchConfigurationTemplateID
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTemplateActionsRequest(
    filters: Optional[zio.aws.mgn.model.TemplateActionsRequestFilters] =
      Optional.Absent,
    launchConfigurationTemplateID: LaunchConfigurationTemplateID,
    maxResults: Optional[MaxResultsType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest = {
    import ListTemplateActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .launchConfigurationTemplateID(
        LaunchConfigurationTemplateID.unwrap(
          launchConfigurationTemplateID
        ): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListTemplateActionsRequest.ReadOnly =
    zio.aws.mgn.model.ListTemplateActionsRequest.wrap(buildAwsValue())
}
object ListTemplateActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListTemplateActionsRequest =
      zio.aws.mgn.model.ListTemplateActionsRequest(
        filters.map(value => value.asEditable),
        launchConfigurationTemplateID,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Optional[zio.aws.mgn.model.TemplateActionsRequestFilters.ReadOnly]
    def launchConfigurationTemplateID: LaunchConfigurationTemplateID
    def maxResults: Optional[MaxResultsType]
    def nextToken: Optional[PaginationToken]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.TemplateActionsRequestFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLaunchConfigurationTemplateID
        : ZIO[Any, Nothing, LaunchConfigurationTemplateID] =
      ZIO.succeed(launchConfigurationTemplateID)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest
  ) extends zio.aws.mgn.model.ListTemplateActionsRequest.ReadOnly {
    override val filters
        : Optional[zio.aws.mgn.model.TemplateActionsRequestFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          zio.aws.mgn.model.TemplateActionsRequestFilters.wrap(value)
        )
    override val launchConfigurationTemplateID: LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives
        .LaunchConfigurationTemplateID(impl.launchConfigurationTemplateID())
    override val maxResults: Optional[MaxResultsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.MaxResultsType(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest
  ): zio.aws.mgn.model.ListTemplateActionsRequest.ReadOnly = new Wrapper(impl)
}
