package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{TagValue, TagKey, SourceServerID}
import scala.jdk.CollectionConverters._
final case class TerminateTargetInstancesRequest(
    sourceServerIDs: Iterable[SourceServerID],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest = {
    import TerminateTargetInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest
      .builder()
      .sourceServerIDs(sourceServerIDs.map { item =>
        SourceServerID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.TerminateTargetInstancesRequest.ReadOnly =
    zio.aws.mgn.model.TerminateTargetInstancesRequest.wrap(buildAwsValue())
}
object TerminateTargetInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.TerminateTargetInstancesRequest =
      zio.aws.mgn.model.TerminateTargetInstancesRequest(
        sourceServerIDs,
        tags.map(value => value)
      )
    def sourceServerIDs: List[SourceServerID]
    def tags: Optional[Map[TagKey, TagValue]]
    def getSourceServerIDs: ZIO[Any, Nothing, List[SourceServerID]] =
      ZIO.succeed(sourceServerIDs)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest
  ) extends zio.aws.mgn.model.TerminateTargetInstancesRequest.ReadOnly {
    override val sourceServerIDs: List[SourceServerID] = impl
      .sourceServerIDs()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.SourceServerID(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest
  ): zio.aws.mgn.model.TerminateTargetInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
