package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.BoundedString
import scala.jdk.CollectionConverters._
final case class NetworkInterface(
    ips: Optional[Iterable[BoundedString]] = Optional.Absent,
    isPrimary: Optional[Boolean] = Optional.Absent,
    macAddress: Optional[BoundedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.NetworkInterface
      .builder()
      .optionallyWith(
        ips.map(value =>
          value.map { item =>
            BoundedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ips)
      .optionallyWith(isPrimary.map(value => value: java.lang.Boolean))(
        _.isPrimary
      )
      .optionallyWith(
        macAddress.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.macAddress)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.NetworkInterface.ReadOnly =
    zio.aws.mgn.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.NetworkInterface =
      zio.aws.mgn.model.NetworkInterface(
        ips.map(value => value),
        isPrimary.map(value => value),
        macAddress.map(value => value)
      )
    def ips: Optional[List[BoundedString]]
    def isPrimary: Optional[Boolean]
    def macAddress: Optional[BoundedString]
    def getIps: ZIO[Any, AwsError, List[BoundedString]] =
      AwsError.unwrapOptionField("ips", ips)
    def getIsPrimary: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPrimary", isPrimary)
    def getMacAddress: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("macAddress", macAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.NetworkInterface
  ) extends zio.aws.mgn.model.NetworkInterface.ReadOnly {
    override val ips: Optional[List[BoundedString]] = zio.aws.core.internal
      .optionalFromNullable(impl.ips())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.BoundedString(item)
        }.toList
      )
    override val isPrimary: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPrimary())
      .map(value => value: Boolean)
    override val macAddress: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.macAddress())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.NetworkInterface
  ): zio.aws.mgn.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
