package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class MarkAsArchivedRequest(sourceServerID: SourceServerID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest = {
    import MarkAsArchivedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest
      .builder()
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.MarkAsArchivedRequest.ReadOnly =
    zio.aws.mgn.model.MarkAsArchivedRequest.wrap(buildAwsValue())
}
object MarkAsArchivedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.MarkAsArchivedRequest =
      zio.aws.mgn.model.MarkAsArchivedRequest(sourceServerID)
    def sourceServerID: SourceServerID
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest
  ) extends zio.aws.mgn.model.MarkAsArchivedRequest.ReadOnly {
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest
  ): zio.aws.mgn.model.MarkAsArchivedRequest.ReadOnly = new Wrapper(impl)
}
