package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.{SourceServerID, ApplicationID}
import scala.jdk.CollectionConverters._
final case class DisassociateSourceServersRequest(
    applicationID: ApplicationID,
    sourceServerIDs: Iterable[SourceServerID]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest = {
    import DisassociateSourceServersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest
      .builder()
      .applicationID(ApplicationID.unwrap(applicationID): java.lang.String)
      .sourceServerIDs(sourceServerIDs.map { item =>
        SourceServerID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DisassociateSourceServersRequest.ReadOnly =
    zio.aws.mgn.model.DisassociateSourceServersRequest.wrap(buildAwsValue())
}
object DisassociateSourceServersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DisassociateSourceServersRequest =
      zio.aws.mgn.model
        .DisassociateSourceServersRequest(applicationID, sourceServerIDs)
    def applicationID: ApplicationID
    def sourceServerIDs: List[SourceServerID]
    def getApplicationID: ZIO[Any, Nothing, ApplicationID] =
      ZIO.succeed(applicationID)
    def getSourceServerIDs: ZIO[Any, Nothing, List[SourceServerID]] =
      ZIO.succeed(sourceServerIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest
  ) extends zio.aws.mgn.model.DisassociateSourceServersRequest.ReadOnly {
    override val applicationID: ApplicationID =
      zio.aws.mgn.model.primitives.ApplicationID(impl.applicationID())
    override val sourceServerIDs: List[SourceServerID] = impl
      .sourceServerIDs()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.SourceServerID(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest
  ): zio.aws.mgn.model.DisassociateSourceServersRequest.ReadOnly = new Wrapper(
    impl
  )
}
