package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.LaunchConfigurationTemplateID
import scala.jdk.CollectionConverters._
final case class UpdateLaunchConfigurationTemplateRequest(
    launchConfigurationTemplateID: LaunchConfigurationTemplateID,
    postLaunchActions: Optional[zio.aws.mgn.model.PostLaunchActions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest = {
    import UpdateLaunchConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest
      .builder()
      .launchConfigurationTemplateID(
        LaunchConfigurationTemplateID.unwrap(
          launchConfigurationTemplateID
        ): java.lang.String
      )
      .optionallyWith(postLaunchActions.map(value => value.buildAwsValue()))(
        _.postLaunchActions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest.ReadOnly =
    zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateLaunchConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest =
      zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest(
        launchConfigurationTemplateID,
        postLaunchActions.map(value => value.asEditable)
      )
    def launchConfigurationTemplateID: LaunchConfigurationTemplateID
    def postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly]
    def getLaunchConfigurationTemplateID
        : ZIO[Any, Nothing, LaunchConfigurationTemplateID] =
      ZIO.succeed(launchConfigurationTemplateID)
    def getPostLaunchActions
        : ZIO[Any, AwsError, zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      AwsError.unwrapOptionField("postLaunchActions", postLaunchActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest
  ) extends zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest.ReadOnly {
    override val launchConfigurationTemplateID: LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives
        .LaunchConfigurationTemplateID(impl.launchConfigurationTemplateID())
    override val postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postLaunchActions())
        .map(value => zio.aws.mgn.model.PostLaunchActions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest
  ): zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
