package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, EC2InstanceID}
import scala.jdk.CollectionConverters._
final case class ParticipatingServer(
    launchStatus: Optional[zio.aws.mgn.model.LaunchStatus] = Optional.Absent,
    launchedEc2InstanceID: Optional[EC2InstanceID] = Optional.Absent,
    postLaunchActionsStatus: Optional[
      zio.aws.mgn.model.PostLaunchActionsStatus
    ] = Optional.Absent,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ParticipatingServer = {
    import ParticipatingServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ParticipatingServer
      .builder()
      .optionallyWith(launchStatus.map(value => value.unwrap))(_.launchStatus)
      .optionallyWith(
        launchedEc2InstanceID.map(value =>
          EC2InstanceID.unwrap(value): java.lang.String
        )
      )(_.launchedEc2InstanceID)
      .optionallyWith(
        postLaunchActionsStatus.map(value => value.buildAwsValue())
      )(_.postLaunchActionsStatus)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ParticipatingServer.ReadOnly =
    zio.aws.mgn.model.ParticipatingServer.wrap(buildAwsValue())
}
object ParticipatingServer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ParticipatingServer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ParticipatingServer =
      zio.aws.mgn.model.ParticipatingServer(
        launchStatus.map(value => value),
        launchedEc2InstanceID.map(value => value),
        postLaunchActionsStatus.map(value => value.asEditable),
        sourceServerID
      )
    def launchStatus: Optional[zio.aws.mgn.model.LaunchStatus]
    def launchedEc2InstanceID: Optional[EC2InstanceID]
    def postLaunchActionsStatus
        : Optional[zio.aws.mgn.model.PostLaunchActionsStatus.ReadOnly]
    def sourceServerID: SourceServerID
    def getLaunchStatus: ZIO[Any, AwsError, zio.aws.mgn.model.LaunchStatus] =
      AwsError.unwrapOptionField("launchStatus", launchStatus)
    def getLaunchedEc2InstanceID: ZIO[Any, AwsError, EC2InstanceID] =
      AwsError.unwrapOptionField("launchedEc2InstanceID", launchedEc2InstanceID)
    def getPostLaunchActionsStatus: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.PostLaunchActionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "postLaunchActionsStatus",
      postLaunchActionsStatus
    )
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ParticipatingServer
  ) extends zio.aws.mgn.model.ParticipatingServer.ReadOnly {
    override val launchStatus: Optional[zio.aws.mgn.model.LaunchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchStatus())
        .map(value => zio.aws.mgn.model.LaunchStatus.wrap(value))
    override val launchedEc2InstanceID: Optional[EC2InstanceID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchedEc2InstanceID())
        .map(value => zio.aws.mgn.model.primitives.EC2InstanceID(value))
    override val postLaunchActionsStatus
        : Optional[zio.aws.mgn.model.PostLaunchActionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postLaunchActionsStatus())
        .map(value => zio.aws.mgn.model.PostLaunchActionsStatus.wrap(value))
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ParticipatingServer
  ): zio.aws.mgn.model.ParticipatingServer.ReadOnly = new Wrapper(impl)
}
