package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.mgn.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListTagsForResourceRequest =
      zio.aws.mgn.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ARN
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest
  ) extends zio.aws.mgn.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.mgn.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest
  ): zio.aws.mgn.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
