package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  TagValue,
  TagKey,
  LaunchConfigurationTemplateID,
  ARN
}
import scala.jdk.CollectionConverters._
final case class LaunchConfigurationTemplate(
    arn: Optional[ARN] = Optional.Absent,
    launchConfigurationTemplateID: LaunchConfigurationTemplateID,
    postLaunchActions: Optional[zio.aws.mgn.model.PostLaunchActions] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LaunchConfigurationTemplate = {
    import LaunchConfigurationTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LaunchConfigurationTemplate
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .launchConfigurationTemplateID(
        LaunchConfigurationTemplateID.unwrap(
          launchConfigurationTemplateID
        ): java.lang.String
      )
      .optionallyWith(postLaunchActions.map(value => value.buildAwsValue()))(
        _.postLaunchActions
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LaunchConfigurationTemplate.ReadOnly =
    zio.aws.mgn.model.LaunchConfigurationTemplate.wrap(buildAwsValue())
}
object LaunchConfigurationTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LaunchConfigurationTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LaunchConfigurationTemplate =
      zio.aws.mgn.model.LaunchConfigurationTemplate(
        arn.map(value => value),
        launchConfigurationTemplateID,
        postLaunchActions.map(value => value.asEditable),
        tags.map(value => value)
      )
    def arn: Optional[ARN]
    def launchConfigurationTemplateID: LaunchConfigurationTemplateID
    def postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getLaunchConfigurationTemplateID
        : ZIO[Any, Nothing, LaunchConfigurationTemplateID] =
      ZIO.succeed(launchConfigurationTemplateID)
    def getPostLaunchActions
        : ZIO[Any, AwsError, zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      AwsError.unwrapOptionField("postLaunchActions", postLaunchActions)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LaunchConfigurationTemplate
  ) extends zio.aws.mgn.model.LaunchConfigurationTemplate.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val launchConfigurationTemplateID: LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives
        .LaunchConfigurationTemplateID(impl.launchConfigurationTemplateID())
    override val postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postLaunchActions())
        .map(value => zio.aws.mgn.model.PostLaunchActions.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LaunchConfigurationTemplate
  ): zio.aws.mgn.model.LaunchConfigurationTemplate.ReadOnly = new Wrapper(impl)
}
