package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class DisconnectFromServiceRequest(sourceServerID: SourceServerID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest = {
    import DisconnectFromServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest
      .builder()
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DisconnectFromServiceRequest.ReadOnly =
    zio.aws.mgn.model.DisconnectFromServiceRequest.wrap(buildAwsValue())
}
object DisconnectFromServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DisconnectFromServiceRequest =
      zio.aws.mgn.model.DisconnectFromServiceRequest(sourceServerID)
    def sourceServerID: SourceServerID
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest
  ) extends zio.aws.mgn.model.DisconnectFromServiceRequest.ReadOnly {
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest
  ): zio.aws.mgn.model.DisconnectFromServiceRequest.ReadOnly = new Wrapper(impl)
}
