package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class PostLaunchActionsStatus(
    postLaunchActionsLaunchStatusList: Optional[
      Iterable[zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus]
    ] = Optional.Absent,
    ssmAgentDiscoveryDatetime: Optional[ISO8601DatetimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.PostLaunchActionsStatus = {
    import PostLaunchActionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.PostLaunchActionsStatus
      .builder()
      .optionallyWith(
        postLaunchActionsLaunchStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.postLaunchActionsLaunchStatusList)
      .optionallyWith(
        ssmAgentDiscoveryDatetime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.ssmAgentDiscoveryDatetime)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.PostLaunchActionsStatus.ReadOnly =
    zio.aws.mgn.model.PostLaunchActionsStatus.wrap(buildAwsValue())
}
object PostLaunchActionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.PostLaunchActionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.PostLaunchActionsStatus =
      zio.aws.mgn.model.PostLaunchActionsStatus(
        postLaunchActionsLaunchStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ssmAgentDiscoveryDatetime.map(value => value)
      )
    def postLaunchActionsLaunchStatusList: Optional[
      List[zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus.ReadOnly]
    ]
    def ssmAgentDiscoveryDatetime: Optional[ISO8601DatetimeString]
    def getPostLaunchActionsLaunchStatusList: ZIO[Any, AwsError, List[
      zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "postLaunchActionsLaunchStatusList",
      postLaunchActionsLaunchStatusList
    )
    def getSsmAgentDiscoveryDatetime
        : ZIO[Any, AwsError, ISO8601DatetimeString] = AwsError
      .unwrapOptionField("ssmAgentDiscoveryDatetime", ssmAgentDiscoveryDatetime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.PostLaunchActionsStatus
  ) extends zio.aws.mgn.model.PostLaunchActionsStatus.ReadOnly {
    override val postLaunchActionsLaunchStatusList: Optional[
      List[zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.postLaunchActionsLaunchStatusList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus.wrap(item)
        }.toList
      )
    override val ssmAgentDiscoveryDatetime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmAgentDiscoveryDatetime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.PostLaunchActionsStatus
  ): zio.aws.mgn.model.PostLaunchActionsStatus.ReadOnly = new Wrapper(impl)
}
