package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  BoundedString,
  S3LogBucketName,
  CloudWatchLogGroupName
}
import scala.jdk.CollectionConverters._
final case class PostLaunchActions(
    cloudWatchLogGroupName: Optional[CloudWatchLogGroupName] = Optional.Absent,
    deployment: Optional[zio.aws.mgn.model.PostLaunchActionsDeploymentType] =
      Optional.Absent,
    s3LogBucket: Optional[S3LogBucketName] = Optional.Absent,
    s3OutputKeyPrefix: Optional[BoundedString] = Optional.Absent,
    ssmDocuments: Optional[Iterable[zio.aws.mgn.model.SsmDocument]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.PostLaunchActions = {
    import PostLaunchActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.PostLaunchActions
      .builder()
      .optionallyWith(
        cloudWatchLogGroupName.map(value =>
          CloudWatchLogGroupName.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupName)
      .optionallyWith(deployment.map(value => value.unwrap))(_.deployment)
      .optionallyWith(
        s3LogBucket.map(value =>
          S3LogBucketName.unwrap(value): java.lang.String
        )
      )(_.s3LogBucket)
      .optionallyWith(
        s3OutputKeyPrefix.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.s3OutputKeyPrefix)
      .optionallyWith(
        ssmDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ssmDocuments)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.PostLaunchActions.ReadOnly =
    zio.aws.mgn.model.PostLaunchActions.wrap(buildAwsValue())
}
object PostLaunchActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.PostLaunchActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.PostLaunchActions =
      zio.aws.mgn.model.PostLaunchActions(
        cloudWatchLogGroupName.map(value => value),
        deployment.map(value => value),
        s3LogBucket.map(value => value),
        s3OutputKeyPrefix.map(value => value),
        ssmDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudWatchLogGroupName: Optional[CloudWatchLogGroupName]
    def deployment: Optional[zio.aws.mgn.model.PostLaunchActionsDeploymentType]
    def s3LogBucket: Optional[S3LogBucketName]
    def s3OutputKeyPrefix: Optional[BoundedString]
    def ssmDocuments: Optional[List[zio.aws.mgn.model.SsmDocument.ReadOnly]]
    def getCloudWatchLogGroupName: ZIO[Any, AwsError, CloudWatchLogGroupName] =
      AwsError.unwrapOptionField(
        "cloudWatchLogGroupName",
        cloudWatchLogGroupName
      )
    def getDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.PostLaunchActionsDeploymentType
    ] = AwsError.unwrapOptionField("deployment", deployment)
    def getS3LogBucket: ZIO[Any, AwsError, S3LogBucketName] =
      AwsError.unwrapOptionField("s3LogBucket", s3LogBucket)
    def getS3OutputKeyPrefix: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("s3OutputKeyPrefix", s3OutputKeyPrefix)
    def getSsmDocuments
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.SsmDocument.ReadOnly]] =
      AwsError.unwrapOptionField("ssmDocuments", ssmDocuments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.PostLaunchActions
  ) extends zio.aws.mgn.model.PostLaunchActions.ReadOnly {
    override val cloudWatchLogGroupName: Optional[CloudWatchLogGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupName())
        .map(value =>
          zio.aws.mgn.model.primitives.CloudWatchLogGroupName(value)
        )
    override val deployment
        : Optional[zio.aws.mgn.model.PostLaunchActionsDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployment())
        .map(value =>
          zio.aws.mgn.model.PostLaunchActionsDeploymentType.wrap(value)
        )
    override val s3LogBucket: Optional[S3LogBucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3LogBucket())
      .map(value => zio.aws.mgn.model.primitives.S3LogBucketName(value))
    override val s3OutputKeyPrefix: Optional[BoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3OutputKeyPrefix())
        .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val ssmDocuments
        : Optional[List[zio.aws.mgn.model.SsmDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.SsmDocument.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.PostLaunchActions
  ): zio.aws.mgn.model.PostLaunchActions.ReadOnly = new Wrapper(impl)
}
