package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class LifeCycleLastCutoverReverted(
    apiCallDateTime: Optional[ISO8601DatetimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverReverted = {
    import LifeCycleLastCutoverReverted.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverReverted
      .builder()
      .optionallyWith(
        apiCallDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.apiCallDateTime)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly =
    zio.aws.mgn.model.LifeCycleLastCutoverReverted.wrap(buildAwsValue())
}
object LifeCycleLastCutoverReverted {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverReverted
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycleLastCutoverReverted =
      zio.aws.mgn.model
        .LifeCycleLastCutoverReverted(apiCallDateTime.map(value => value))
    def apiCallDateTime: Optional[ISO8601DatetimeString]
    def getApiCallDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("apiCallDateTime", apiCallDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverReverted
  ) extends zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly {
    override val apiCallDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCallDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverReverted
  ): zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly = new Wrapper(impl)
}
