package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  PaginationToken,
  StrictlyPositiveInteger,
  LaunchConfigurationTemplateID
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeLaunchConfigurationTemplatesRequest(
    launchConfigurationTemplateIDs: Optional[
      Iterable[LaunchConfigurationTemplateID]
    ] = Optional.Absent,
    maxResults: Optional[StrictlyPositiveInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest = {
    import DescribeLaunchConfigurationTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest
      .builder()
      .optionallyWith(
        launchConfigurationTemplateIDs.map(value =>
          value.map { item =>
            LaunchConfigurationTemplateID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.launchConfigurationTemplateIDs)
      .optionallyWith(
        maxResults.map(value => StrictlyPositiveInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest.ReadOnly =
    zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest
      .wrap(buildAwsValue())
}
object DescribeLaunchConfigurationTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest =
      zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest(
        launchConfigurationTemplateIDs.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def launchConfigurationTemplateIDs
        : Optional[List[LaunchConfigurationTemplateID]]
    def maxResults: Optional[StrictlyPositiveInteger]
    def nextToken: Optional[PaginationToken]
    def getLaunchConfigurationTemplateIDs
        : ZIO[Any, AwsError, List[LaunchConfigurationTemplateID]] =
      AwsError.unwrapOptionField(
        "launchConfigurationTemplateIDs",
        launchConfigurationTemplateIDs
      )
    def getMaxResults: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest
  ) extends zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest.ReadOnly {
    override val launchConfigurationTemplateIDs
        : Optional[List[LaunchConfigurationTemplateID]] = zio.aws.core.internal
      .optionalFromNullable(impl.launchConfigurationTemplateIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.LaunchConfigurationTemplateID(item)
        }.toList
      )
    override val maxResults: Optional[StrictlyPositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest
  ): zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
