package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class CreateLaunchConfigurationTemplateRequest(
    postLaunchActions: Optional[zio.aws.mgn.model.PostLaunchActions] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest = {
    import CreateLaunchConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest
      .builder()
      .optionallyWith(postLaunchActions.map(value => value.buildAwsValue()))(
        _.postLaunchActions
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest.ReadOnly =
    zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object CreateLaunchConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest =
      zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest(
        postLaunchActions.map(value => value.asEditable),
        tags.map(value => value)
      )
    def postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getPostLaunchActions
        : ZIO[Any, AwsError, zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      AwsError.unwrapOptionField("postLaunchActions", postLaunchActions)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest
  ) extends zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest.ReadOnly {
    override val postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postLaunchActions())
        .map(value => zio.aws.mgn.model.PostLaunchActions.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest
  ): zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
