package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeReplicationConfigurationTemplatesResponse(
    items: Optional[
      Iterable[zio.aws.mgn.model.ReplicationConfigurationTemplate]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse = {
    import DescribeReplicationConfigurationTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly =
    zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationConfigurationTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse =
      zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[
      List[zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse
  ) extends zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly {
    override val items: Optional[
      List[zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.ReplicationConfigurationTemplate.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse
  ): zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
