package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class ChangeServerLifeCycleStateRequest(
    lifeCycle: zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest = {
    import ChangeServerLifeCycleStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest
      .builder()
      .lifeCycle(lifeCycle.buildAwsValue())
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ChangeServerLifeCycleStateRequest.ReadOnly =
    zio.aws.mgn.model.ChangeServerLifeCycleStateRequest.wrap(buildAwsValue())
}
object ChangeServerLifeCycleStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ChangeServerLifeCycleStateRequest =
      zio.aws.mgn.model
        .ChangeServerLifeCycleStateRequest(lifeCycle.asEditable, sourceServerID)
    def lifeCycle
        : zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle.ReadOnly
    def sourceServerID: SourceServerID
    def getLifeCycle: ZIO[
      Any,
      Nothing,
      zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle.ReadOnly
    ] = ZIO.succeed(lifeCycle)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest
  ) extends zio.aws.mgn.model.ChangeServerLifeCycleStateRequest.ReadOnly {
    override val lifeCycle
        : zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle.ReadOnly =
      zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle
        .wrap(impl.lifeCycle())
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest
  ): zio.aws.mgn.model.ChangeServerLifeCycleStateRequest.ReadOnly = new Wrapper(
    impl
  )
}
