package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{BoundedString, PositiveInteger}
import scala.jdk.CollectionConverters._
final case class CPU(
    cores: Optional[PositiveInteger] = Optional.Absent,
    modelName: Optional[BoundedString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.CPU = {
    import CPU.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.CPU
      .builder()
      .optionallyWith(
        cores.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.cores)
      .optionallyWith(
        modelName.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.modelName)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.CPU.ReadOnly =
    zio.aws.mgn.model.CPU.wrap(buildAwsValue())
}
object CPU {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.CPU] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.CPU = zio.aws.mgn.model
      .CPU(cores.map(value => value), modelName.map(value => value))
    def cores: Optional[PositiveInteger]
    def modelName: Optional[BoundedString]
    def getCores: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("cores", cores)
    def getModelName: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("modelName", modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.CPU
  ) extends zio.aws.mgn.model.CPU.ReadOnly {
    override val cores: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.cores())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val modelName: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.CPU
  ): zio.aws.mgn.model.CPU.ReadOnly = new Wrapper(impl)
}
