package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait DataReplicationState {
  def unwrap: software.amazon.awssdk.services.mgn.model.DataReplicationState
}
object DataReplicationState {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.DataReplicationState
  ): zio.aws.mgn.model.DataReplicationState = value match {
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.INITIATING =>
      val r = INITIATING
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.INITIAL_SYNC =>
      val r = INITIAL_SYNC
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.BACKLOG =>
      val r = BACKLOG
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.CREATING_SNAPSHOT =>
      val r = CREATING_SNAPSHOT
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.CONTINUOUS =>
      val r = CONTINUOUS
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.PAUSED =>
      val r = PAUSED
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.RESCAN =>
      val r = RESCAN
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.STALLED =>
      val r = STALLED
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.DISCONNECTED =>
      val r = DISCONNECTED
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.PENDING_SNAPSHOT_SHIPPING =>
      val r = PENDING_SNAPSHOT_SHIPPING
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationState.SHIPPING_SNAPSHOT =>
      val r = SHIPPING_SNAPSHOT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.UNKNOWN_TO_SDK_VERSION
  }
  case object STOPPED extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.STOPPED
  }
  case object INITIATING extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.INITIATING
  }
  case object INITIAL_SYNC extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.INITIAL_SYNC
  }
  case object BACKLOG extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.BACKLOG
  }
  case object CREATING_SNAPSHOT extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.CREATING_SNAPSHOT
  }
  case object CONTINUOUS extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.CONTINUOUS
  }
  case object PAUSED extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.PAUSED
  }
  case object RESCAN extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.RESCAN
  }
  case object STALLED extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.STALLED
  }
  case object DISCONNECTED extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.DISCONNECTED
  }
  case object PENDING_SNAPSHOT_SHIPPING
      extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.PENDING_SNAPSHOT_SHIPPING
  }
  case object SHIPPING_SNAPSHOT extends zio.aws.mgn.model.DataReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationState =
      software.amazon.awssdk.services.mgn.model.DataReplicationState.SHIPPING_SNAPSHOT
  }
}
