package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  PaginationToken,
  StrictlyPositiveInteger,
  JobID
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeJobLogItemsRequest(
    jobID: JobID,
    maxResults: Optional[StrictlyPositiveInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest = {
    import DescribeJobLogItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest
      .builder()
      .jobID(JobID.unwrap(jobID): java.lang.String)
      .optionallyWith(
        maxResults.map(value => StrictlyPositiveInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeJobLogItemsRequest.ReadOnly =
    zio.aws.mgn.model.DescribeJobLogItemsRequest.wrap(buildAwsValue())
}
object DescribeJobLogItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeJobLogItemsRequest =
      zio.aws.mgn.model.DescribeJobLogItemsRequest(
        jobID,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobID: JobID
    def maxResults: Optional[StrictlyPositiveInteger]
    def nextToken: Optional[PaginationToken]
    def getJobID: ZIO[Any, Nothing, JobID] = ZIO.succeed(jobID)
    def getMaxResults: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest
  ) extends zio.aws.mgn.model.DescribeJobLogItemsRequest.ReadOnly {
    override val jobID: JobID = zio.aws.mgn.model.primitives.JobID(impl.jobID())
    override val maxResults: Optional[StrictlyPositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest
  ): zio.aws.mgn.model.DescribeJobLogItemsRequest.ReadOnly = new Wrapper(impl)
}
