package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait DataReplicationErrorString {
  def unwrap
      : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString
}
object DataReplicationErrorString {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.DataReplicationErrorString
  ): zio.aws.mgn.model.DataReplicationErrorString = value match {
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.AGENT_NOT_SEEN =>
      val r = AGENT_NOT_SEEN
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.SNAPSHOTS_FAILURE =>
      val r = SNAPSHOTS_FAILURE
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.NOT_CONVERGING =>
      val r = NOT_CONVERGING
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.UNSTABLE_NETWORK =>
      val r = UNSTABLE_NETWORK
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_CREATE_SECURITY_GROUP =>
      val r = FAILED_TO_CREATE_SECURITY_GROUP
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_LAUNCH_REPLICATION_SERVER =>
      val r = FAILED_TO_LAUNCH_REPLICATION_SERVER
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_BOOT_REPLICATION_SERVER =>
      val r = FAILED_TO_BOOT_REPLICATION_SERVER
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_AUTHENTICATE_WITH_SERVICE =>
      val r = FAILED_TO_AUTHENTICATE_WITH_SERVICE
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE =>
      val r = FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_CREATE_STAGING_DISKS =>
      val r = FAILED_TO_CREATE_STAGING_DISKS
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_ATTACH_STAGING_DISKS =>
      val r = FAILED_TO_ATTACH_STAGING_DISKS
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT =>
      val r = FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER =>
      val r = FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_START_DATA_TRANSFER =>
      val r = FAILED_TO_START_DATA_TRANSFER
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.UNSUPPORTED_VM_CONFIGURATION =>
      val r = UNSUPPORTED_VM_CONFIGURATION
      r
    case software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.LAST_SNAPSHOT_JOB_FAILED =>
      val r = LAST_SNAPSHOT_JOB_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.UNKNOWN_TO_SDK_VERSION
  }
  case object AGENT_NOT_SEEN
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.AGENT_NOT_SEEN
  }
  case object SNAPSHOTS_FAILURE
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.SNAPSHOTS_FAILURE
  }
  case object NOT_CONVERGING
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.NOT_CONVERGING
  }
  case object UNSTABLE_NETWORK
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.UNSTABLE_NETWORK
  }
  case object FAILED_TO_CREATE_SECURITY_GROUP
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_CREATE_SECURITY_GROUP
  }
  case object FAILED_TO_LAUNCH_REPLICATION_SERVER
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_LAUNCH_REPLICATION_SERVER
  }
  case object FAILED_TO_BOOT_REPLICATION_SERVER
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_BOOT_REPLICATION_SERVER
  }
  case object FAILED_TO_AUTHENTICATE_WITH_SERVICE
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_AUTHENTICATE_WITH_SERVICE
  }
  case object FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE
  }
  case object FAILED_TO_CREATE_STAGING_DISKS
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_CREATE_STAGING_DISKS
  }
  case object FAILED_TO_ATTACH_STAGING_DISKS
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_ATTACH_STAGING_DISKS
  }
  case object FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT
  }
  case object FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER
  }
  case object FAILED_TO_START_DATA_TRANSFER
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.FAILED_TO_START_DATA_TRANSFER
  }
  case object UNSUPPORTED_VM_CONFIGURATION
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.UNSUPPORTED_VM_CONFIGURATION
  }
  case object LAST_SNAPSHOT_JOB_FAILED
      extends zio.aws.mgn.model.DataReplicationErrorString {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.DataReplicationErrorString =
      software.amazon.awssdk.services.mgn.model.DataReplicationErrorString.LAST_SNAPSHOT_JOB_FAILED
  }
}
