package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class DescribeSourceServersRequestFilters(
    isArchived: Optional[Boolean] = Optional.Absent,
    lifeCycleStates: Optional[Iterable[zio.aws.mgn.model.LifeCycleState]] =
      Optional.Absent,
    replicationTypes: Optional[Iterable[zio.aws.mgn.model.ReplicationType]] =
      Optional.Absent,
    sourceServerIDs: Optional[Iterable[SourceServerID]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters = {
    import DescribeSourceServersRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters
      .builder()
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(
        lifeCycleStates.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.lifeCycleStatesWithStrings)
      .optionallyWith(
        replicationTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.replicationTypesWithStrings)
      .optionallyWith(
        sourceServerIDs.map(value =>
          value.map { item =>
            SourceServerID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sourceServerIDs)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly =
    zio.aws.mgn.model.DescribeSourceServersRequestFilters.wrap(buildAwsValue())
}
object DescribeSourceServersRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeSourceServersRequestFilters =
      zio.aws.mgn.model.DescribeSourceServersRequestFilters(
        isArchived.map(value => value),
        lifeCycleStates.map(value => value),
        replicationTypes.map(value => value),
        sourceServerIDs.map(value => value)
      )
    def isArchived: Optional[Boolean]
    def lifeCycleStates: Optional[List[zio.aws.mgn.model.LifeCycleState]]
    def replicationTypes: Optional[List[zio.aws.mgn.model.ReplicationType]]
    def sourceServerIDs: Optional[List[SourceServerID]]
    def getIsArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLifeCycleStates
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.LifeCycleState]] =
      AwsError.unwrapOptionField("lifeCycleStates", lifeCycleStates)
    def getReplicationTypes
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.ReplicationType]] =
      AwsError.unwrapOptionField("replicationTypes", replicationTypes)
    def getSourceServerIDs: ZIO[Any, AwsError, List[SourceServerID]] =
      AwsError.unwrapOptionField("sourceServerIDs", sourceServerIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters
  ) extends zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly {
    override val isArchived: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArchived())
      .map(value => value: Boolean)
    override val lifeCycleStates
        : Optional[List[zio.aws.mgn.model.LifeCycleState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifeCycleStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.LifeCycleState.wrap(item)
          }.toList
        )
    override val replicationTypes
        : Optional[List[zio.aws.mgn.model.ReplicationType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.ReplicationType.wrap(item)
          }.toList
        )
    override val sourceServerIDs: Optional[List[SourceServerID]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceServerIDs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.primitives.SourceServerID(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters
  ): zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly =
    new Wrapper(impl)
}
