package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{JobID, ISO8601DatetimeString}
import scala.jdk.CollectionConverters._
final case class DescribeJobsRequestFilters(
    fromDate: Optional[ISO8601DatetimeString] = Optional.Absent,
    jobIDs: Optional[Iterable[JobID]] = Optional.Absent,
    toDate: Optional[ISO8601DatetimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters = {
    import DescribeJobsRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters
      .builder()
      .optionallyWith(
        fromDate.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.fromDate)
      .optionallyWith(
        jobIDs.map(value =>
          value.map { item =>
            JobID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobIDs)
      .optionallyWith(
        toDate.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.toDate)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly =
    zio.aws.mgn.model.DescribeJobsRequestFilters.wrap(buildAwsValue())
}
object DescribeJobsRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeJobsRequestFilters =
      zio.aws.mgn.model.DescribeJobsRequestFilters(
        fromDate.map(value => value),
        jobIDs.map(value => value),
        toDate.map(value => value)
      )
    def fromDate: Optional[ISO8601DatetimeString]
    def jobIDs: Optional[List[JobID]]
    def toDate: Optional[ISO8601DatetimeString]
    def getFromDate: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("fromDate", fromDate)
    def getJobIDs: ZIO[Any, AwsError, List[JobID]] =
      AwsError.unwrapOptionField("jobIDs", jobIDs)
    def getToDate: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("toDate", toDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters
  ) extends zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly {
    override val fromDate: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromDate())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val jobIDs: Optional[List[JobID]] = zio.aws.core.internal
      .optionalFromNullable(impl.jobIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.JobID(item)
        }.toList
      )
    override val toDate: Optional[ISO8601DatetimeString] = zio.aws.core.internal
      .optionalFromNullable(impl.toDate())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters
  ): zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly = new Wrapper(impl)
}
