package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{BoundedString, PositiveInteger}
import scala.jdk.CollectionConverters._
final case class DataReplicationInfoReplicatedDisk(
    backloggedStorageBytes: Optional[PositiveInteger] = Optional.Absent,
    deviceName: Optional[BoundedString] = Optional.Absent,
    replicatedStorageBytes: Optional[PositiveInteger] = Optional.Absent,
    rescannedStorageBytes: Optional[PositiveInteger] = Optional.Absent,
    totalStorageBytes: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk = {
    import DataReplicationInfoReplicatedDisk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk
      .builder()
      .optionallyWith(
        backloggedStorageBytes.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.backloggedStorageBytes)
      .optionallyWith(
        deviceName.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        replicatedStorageBytes.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.replicatedStorageBytes)
      .optionallyWith(
        rescannedStorageBytes.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.rescannedStorageBytes)
      .optionallyWith(
        totalStorageBytes.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.totalStorageBytes)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly =
    zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.wrap(buildAwsValue())
}
object DataReplicationInfoReplicatedDisk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DataReplicationInfoReplicatedDisk =
      zio.aws.mgn.model.DataReplicationInfoReplicatedDisk(
        backloggedStorageBytes.map(value => value),
        deviceName.map(value => value),
        replicatedStorageBytes.map(value => value),
        rescannedStorageBytes.map(value => value),
        totalStorageBytes.map(value => value)
      )
    def backloggedStorageBytes: Optional[PositiveInteger]
    def deviceName: Optional[BoundedString]
    def replicatedStorageBytes: Optional[PositiveInteger]
    def rescannedStorageBytes: Optional[PositiveInteger]
    def totalStorageBytes: Optional[PositiveInteger]
    def getBackloggedStorageBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField(
        "backloggedStorageBytes",
        backloggedStorageBytes
      )
    def getDeviceName: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getReplicatedStorageBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField(
        "replicatedStorageBytes",
        replicatedStorageBytes
      )
    def getRescannedStorageBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("rescannedStorageBytes", rescannedStorageBytes)
    def getTotalStorageBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("totalStorageBytes", totalStorageBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk
  ) extends zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly {
    override val backloggedStorageBytes: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backloggedStorageBytes())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val deviceName: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val replicatedStorageBytes: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicatedStorageBytes())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val rescannedStorageBytes: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rescannedStorageBytes())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val totalStorageBytes: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStorageBytes())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk
  ): zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly = new Wrapper(
    impl
  )
}
