package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.JobID
import scala.jdk.CollectionConverters._
final case class DeleteJobRequest(jobID: JobID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteJobRequest = {
    import DeleteJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteJobRequest
      .builder()
      .jobID(JobID.unwrap(jobID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DeleteJobRequest.ReadOnly =
    zio.aws.mgn.model.DeleteJobRequest.wrap(buildAwsValue())
}
object DeleteJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteJobRequest =
      zio.aws.mgn.model.DeleteJobRequest(jobID)
    def jobID: JobID
    def getJobID: ZIO[Any, Nothing, JobID] = ZIO.succeed(jobID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteJobRequest
  ) extends zio.aws.mgn.model.DeleteJobRequest.ReadOnly {
    override val jobID: JobID = zio.aws.mgn.model.primitives.JobID(impl.jobID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteJobRequest
  ): zio.aws.mgn.model.DeleteJobRequest.ReadOnly = new Wrapper(impl)
}
