package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartTestResponse(
    job: Optional[zio.aws.mgn.model.Job] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StartTestResponse = {
    import StartTestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StartTestResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StartTestResponse.ReadOnly =
    zio.aws.mgn.model.StartTestResponse.wrap(buildAwsValue())
}
object StartTestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StartTestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StartTestResponse =
      zio.aws.mgn.model.StartTestResponse(job.map(value => value.asEditable))
    def job: Optional[zio.aws.mgn.model.Job.ReadOnly]
    def getJob: ZIO[Any, AwsError, zio.aws.mgn.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StartTestResponse
  ) extends zio.aws.mgn.model.StartTestResponse.ReadOnly {
    override val job: Optional[zio.aws.mgn.model.Job.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.job())
        .map(value => zio.aws.mgn.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StartTestResponse
  ): zio.aws.mgn.model.StartTestResponse.ReadOnly = new Wrapper(impl)
}
