package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait JobLogEvent {
  def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent
}
object JobLogEvent {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.JobLogEvent
  ): zio.aws.mgn.model.JobLogEvent = value match {
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.JOB_START =>
      val r = JOB_START
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.SERVER_SKIPPED =>
      val r = SERVER_SKIPPED
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.CLEANUP_START =>
      val r = CLEANUP_START
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.CLEANUP_END =>
      val r = CLEANUP_END
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.CLEANUP_FAIL =>
      val r = CLEANUP_FAIL
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.SNAPSHOT_START =>
      val r = SNAPSHOT_START
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.SNAPSHOT_END =>
      val r = SNAPSHOT_END
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.SNAPSHOT_FAIL =>
      val r = SNAPSHOT_FAIL
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.USING_PREVIOUS_SNAPSHOT =>
      val r = USING_PREVIOUS_SNAPSHOT
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.CONVERSION_START =>
      val r = CONVERSION_START
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.CONVERSION_END =>
      val r = CONVERSION_END
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.CONVERSION_FAIL =>
      val r = CONVERSION_FAIL
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.LAUNCH_START =>
      val r = LAUNCH_START
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.LAUNCH_FAILED =>
      val r = LAUNCH_FAILED
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.JOB_CANCEL =>
      val r = JOB_CANCEL
      r
    case software.amazon.awssdk.services.mgn.model.JobLogEvent.JOB_END =>
      val r = JOB_END
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object JOB_START extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.JOB_START
  }
  case object SERVER_SKIPPED extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.SERVER_SKIPPED
  }
  case object CLEANUP_START extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.CLEANUP_START
  }
  case object CLEANUP_END extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.CLEANUP_END
  }
  case object CLEANUP_FAIL extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.CLEANUP_FAIL
  }
  case object SNAPSHOT_START extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.SNAPSHOT_START
  }
  case object SNAPSHOT_END extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.SNAPSHOT_END
  }
  case object SNAPSHOT_FAIL extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.SNAPSHOT_FAIL
  }
  case object USING_PREVIOUS_SNAPSHOT extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.USING_PREVIOUS_SNAPSHOT
  }
  case object CONVERSION_START extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.CONVERSION_START
  }
  case object CONVERSION_END extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.CONVERSION_END
  }
  case object CONVERSION_FAIL extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.CONVERSION_FAIL
  }
  case object LAUNCH_START extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.LAUNCH_START
  }
  case object LAUNCH_FAILED extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.LAUNCH_FAILED
  }
  case object JOB_CANCEL extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.JOB_CANCEL
  }
  case object JOB_END extends zio.aws.mgn.model.JobLogEvent {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobLogEvent =
      software.amazon.awssdk.services.mgn.model.JobLogEvent.JOB_END
  }
}
