package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  JobID,
  TagValue,
  ISO8601DatetimeString,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class Job(
    arn: Optional[ARN] = Optional.Absent,
    creationDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    endDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    initiatedBy: Optional[zio.aws.mgn.model.InitiatedBy] = Optional.Absent,
    jobID: JobID,
    participatingServers: Optional[
      Iterable[zio.aws.mgn.model.ParticipatingServer]
    ] = Optional.Absent,
    status: Optional[zio.aws.mgn.model.JobStatus] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: Optional[zio.aws.mgn.model.JobType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.Job
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        creationDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.creationDateTime)
      .optionallyWith(
        endDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.endDateTime)
      .optionallyWith(initiatedBy.map(value => value.unwrap))(_.initiatedBy)
      .jobID(JobID.unwrap(jobID): java.lang.String)
      .optionallyWith(
        participatingServers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.participatingServers)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.Job.ReadOnly =
    zio.aws.mgn.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.Job = zio.aws.mgn.model.Job(
      arn.map(value => value),
      creationDateTime.map(value => value),
      endDateTime.map(value => value),
      initiatedBy.map(value => value),
      jobID,
      participatingServers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      status.map(value => value),
      tags.map(value => value),
      `type`.map(value => value)
    )
    def arn: Optional[ARN]
    def creationDateTime: Optional[ISO8601DatetimeString]
    def endDateTime: Optional[ISO8601DatetimeString]
    def initiatedBy: Optional[zio.aws.mgn.model.InitiatedBy]
    def jobID: JobID
    def participatingServers
        : Optional[List[zio.aws.mgn.model.ParticipatingServer.ReadOnly]]
    def status: Optional[zio.aws.mgn.model.JobStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: Optional[zio.aws.mgn.model.JobType]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getCreationDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getEndDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
    def getInitiatedBy: ZIO[Any, AwsError, zio.aws.mgn.model.InitiatedBy] =
      AwsError.unwrapOptionField("initiatedBy", initiatedBy)
    def getJobID: ZIO[Any, Nothing, JobID] = ZIO.succeed(jobID)
    def getParticipatingServers: ZIO[Any, AwsError, List[
      zio.aws.mgn.model.ParticipatingServer.ReadOnly
    ]] =
      AwsError.unwrapOptionField("participatingServers", participatingServers)
    def getStatus: ZIO[Any, AwsError, zio.aws.mgn.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.mgn.model.JobType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.Job
  ) extends zio.aws.mgn.model.Job.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val creationDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val endDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val initiatedBy: Optional[zio.aws.mgn.model.InitiatedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiatedBy())
        .map(value => zio.aws.mgn.model.InitiatedBy.wrap(value))
    override val jobID: JobID = zio.aws.mgn.model.primitives.JobID(impl.jobID())
    override val participatingServers
        : Optional[List[zio.aws.mgn.model.ParticipatingServer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participatingServers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.ParticipatingServer.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.mgn.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.mgn.model.JobStatus.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.mgn.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.mgn.model.JobType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.Job
  ): zio.aws.mgn.model.Job.ReadOnly = new Wrapper(impl)
}
