package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.{TagValue, TagKey, ARN}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ARN,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.TagResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.TagResourceRequest.ReadOnly =
    zio.aws.mgn.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.TagResourceRequest =
      zio.aws.mgn.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ARN
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.TagResourceRequest
  ) extends zio.aws.mgn.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.mgn.model.primitives.ARN(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.mgn.model.primitives.TagKey(key) -> zio.aws.mgn.model.primitives
          .TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.TagResourceRequest
  ): zio.aws.mgn.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
