package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataReplicationInitiationStep(
    name: Option[zio.aws.mgn.model.DataReplicationInitiationStepName] = None,
    status: Option[zio.aws.mgn.model.DataReplicationInitiationStepStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep = {
    import DataReplicationInitiationStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly =
    zio.aws.mgn.model.DataReplicationInitiationStep.wrap(buildAwsValue())
}
object DataReplicationInitiationStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DataReplicationInitiationStep =
      zio.aws.mgn.model.DataReplicationInitiationStep(
        name.map(value => value),
        status.map(value => value)
      )
    def name: Option[zio.aws.mgn.model.DataReplicationInitiationStepName]
    def status: Option[zio.aws.mgn.model.DataReplicationInitiationStepStatus]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.DataReplicationInitiationStepName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.DataReplicationInitiationStepStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep
  ) extends zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly {
    override val name
        : Option[zio.aws.mgn.model.DataReplicationInitiationStepName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.mgn.model.DataReplicationInitiationStepName.wrap(value)
      )
    override val status
        : Option[zio.aws.mgn.model.DataReplicationInitiationStepStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.mgn.model.DataReplicationInitiationStepStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep
  ): zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly = new Wrapper(
    impl
  )
}
