package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartCutoverResponse(
    job: Option[zio.aws.mgn.model.Job] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StartCutoverResponse = {
    import StartCutoverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StartCutoverResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StartCutoverResponse.ReadOnly =
    zio.aws.mgn.model.StartCutoverResponse.wrap(buildAwsValue())
}
object StartCutoverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StartCutoverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StartCutoverResponse =
      zio.aws.mgn.model.StartCutoverResponse(job.map(value => value.asEditable))
    def job: Option[zio.aws.mgn.model.Job.ReadOnly]
    def getJob: ZIO[Any, AwsError, zio.aws.mgn.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StartCutoverResponse
  ) extends zio.aws.mgn.model.StartCutoverResponse.ReadOnly {
    override val job: Option[zio.aws.mgn.model.Job.ReadOnly] =
      scala.Option(impl.job()).map(value => zio.aws.mgn.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StartCutoverResponse
  ): zio.aws.mgn.model.StartCutoverResponse.ReadOnly = new Wrapper(impl)
}
