package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  EC2InstanceType,
  PositiveInteger,
  ISO8601DatetimeString
}
import scala.jdk.CollectionConverters._
final case class SourceProperties(
    cpus: Option[Iterable[zio.aws.mgn.model.CPU]] = None,
    disks: Option[Iterable[zio.aws.mgn.model.Disk]] = None,
    identificationHints: Option[zio.aws.mgn.model.IdentificationHints] = None,
    lastUpdatedDateTime: Option[ISO8601DatetimeString] = None,
    networkInterfaces: Option[Iterable[zio.aws.mgn.model.NetworkInterface]] =
      None,
    os: Option[zio.aws.mgn.model.OS] = None,
    ramBytes: Option[PositiveInteger] = None,
    recommendedInstanceType: Option[EC2InstanceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.SourceProperties = {
    import SourceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.SourceProperties
      .builder()
      .optionallyWith(
        cpus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cpus)
      .optionallyWith(
        disks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.disks)
      .optionallyWith(identificationHints.map(value => value.buildAwsValue()))(
        _.identificationHints
      )
      .optionallyWith(
        lastUpdatedDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(os.map(value => value.buildAwsValue()))(_.os)
      .optionallyWith(
        ramBytes.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.ramBytes)
      .optionallyWith(
        recommendedInstanceType.map(value =>
          EC2InstanceType.unwrap(value): java.lang.String
        )
      )(_.recommendedInstanceType)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.SourceProperties.ReadOnly =
    zio.aws.mgn.model.SourceProperties.wrap(buildAwsValue())
}
object SourceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.SourceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.SourceProperties =
      zio.aws.mgn.model.SourceProperties(
        cpus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        identificationHints.map(value => value.asEditable),
        lastUpdatedDateTime.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        os.map(value => value.asEditable),
        ramBytes.map(value => value),
        recommendedInstanceType.map(value => value)
      )
    def cpus: Option[List[zio.aws.mgn.model.CPU.ReadOnly]]
    def disks: Option[List[zio.aws.mgn.model.Disk.ReadOnly]]
    def identificationHints
        : Option[zio.aws.mgn.model.IdentificationHints.ReadOnly]
    def lastUpdatedDateTime: Option[ISO8601DatetimeString]
    def networkInterfaces
        : Option[List[zio.aws.mgn.model.NetworkInterface.ReadOnly]]
    def os: Option[zio.aws.mgn.model.OS.ReadOnly]
    def ramBytes: Option[PositiveInteger]
    def recommendedInstanceType: Option[EC2InstanceType]
    def getCpus: ZIO[Any, AwsError, List[zio.aws.mgn.model.CPU.ReadOnly]] =
      AwsError.unwrapOptionField("cpus", cpus)
    def getDisks: ZIO[Any, AwsError, List[zio.aws.mgn.model.Disk.ReadOnly]] =
      AwsError.unwrapOptionField("disks", disks)
    def getIdentificationHints
        : ZIO[Any, AwsError, zio.aws.mgn.model.IdentificationHints.ReadOnly] =
      AwsError.unwrapOptionField("identificationHints", identificationHints)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.mgn.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getOs: ZIO[Any, AwsError, zio.aws.mgn.model.OS.ReadOnly] =
      AwsError.unwrapOptionField("os", os)
    def getRamBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("ramBytes", ramBytes)
    def getRecommendedInstanceType: ZIO[Any, AwsError, EC2InstanceType] =
      AwsError.unwrapOptionField(
        "recommendedInstanceType",
        recommendedInstanceType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.SourceProperties
  ) extends zio.aws.mgn.model.SourceProperties.ReadOnly {
    override val cpus: Option[List[zio.aws.mgn.model.CPU.ReadOnly]] = scala
      .Option(impl.cpus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.CPU.wrap(item)
        }.toList
      )
    override val disks: Option[List[zio.aws.mgn.model.Disk.ReadOnly]] = scala
      .Option(impl.disks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.Disk.wrap(item)
        }.toList
      )
    override val identificationHints
        : Option[zio.aws.mgn.model.IdentificationHints.ReadOnly] = scala
      .Option(impl.identificationHints())
      .map(value => zio.aws.mgn.model.IdentificationHints.wrap(value))
    override val lastUpdatedDateTime: Option[ISO8601DatetimeString] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val networkInterfaces
        : Option[List[zio.aws.mgn.model.NetworkInterface.ReadOnly]] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.NetworkInterface.wrap(item)
        }.toList
      )
    override val os: Option[zio.aws.mgn.model.OS.ReadOnly] =
      scala.Option(impl.os()).map(value => zio.aws.mgn.model.OS.wrap(value))
    override val ramBytes: Option[PositiveInteger] = scala
      .Option(impl.ramBytes())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val recommendedInstanceType: Option[EC2InstanceType] = scala
      .Option(impl.recommendedInstanceType())
      .map(value => zio.aws.mgn.model.primitives.EC2InstanceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.SourceProperties
  ): zio.aws.mgn.model.SourceProperties.ReadOnly = new Wrapper(impl)
}
