package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Licensing(osByol: Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.Licensing = {
    import Licensing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.Licensing
      .builder()
      .optionallyWith(osByol.map(value => value: java.lang.Boolean))(_.osByol)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.Licensing.ReadOnly =
    zio.aws.mgn.model.Licensing.wrap(buildAwsValue())
}
object Licensing {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.Licensing] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.Licensing =
      zio.aws.mgn.model.Licensing(osByol.map(value => value))
    def osByol: Option[Boolean]
    def getOsByol: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("osByol", osByol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.Licensing
  ) extends zio.aws.mgn.model.Licensing.ReadOnly {
    override val osByol: Option[Boolean] =
      scala.Option(impl.osByol()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.Licensing
  ): zio.aws.mgn.model.Licensing.ReadOnly = new Wrapper(impl)
}
