package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{JobID, EC2InstanceID}
import scala.jdk.CollectionConverters._
final case class LaunchedInstance(
    ec2InstanceID: Option[EC2InstanceID] = None,
    firstBoot: Option[zio.aws.mgn.model.FirstBoot] = None,
    jobID: Option[JobID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LaunchedInstance = {
    import LaunchedInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LaunchedInstance
      .builder()
      .optionallyWith(
        ec2InstanceID.map(value =>
          EC2InstanceID.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceID)
      .optionallyWith(firstBoot.map(value => value.unwrap))(_.firstBoot)
      .optionallyWith(
        jobID.map(value => JobID.unwrap(value): java.lang.String)
      )(_.jobID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LaunchedInstance.ReadOnly =
    zio.aws.mgn.model.LaunchedInstance.wrap(buildAwsValue())
}
object LaunchedInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LaunchedInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LaunchedInstance =
      zio.aws.mgn.model.LaunchedInstance(
        ec2InstanceID.map(value => value),
        firstBoot.map(value => value),
        jobID.map(value => value)
      )
    def ec2InstanceID: Option[EC2InstanceID]
    def firstBoot: Option[zio.aws.mgn.model.FirstBoot]
    def jobID: Option[JobID]
    def getEc2InstanceID: ZIO[Any, AwsError, EC2InstanceID] =
      AwsError.unwrapOptionField("ec2InstanceID", ec2InstanceID)
    def getFirstBoot: ZIO[Any, AwsError, zio.aws.mgn.model.FirstBoot] =
      AwsError.unwrapOptionField("firstBoot", firstBoot)
    def getJobID: ZIO[Any, AwsError, JobID] =
      AwsError.unwrapOptionField("jobID", jobID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LaunchedInstance
  ) extends zio.aws.mgn.model.LaunchedInstance.ReadOnly {
    override val ec2InstanceID: Option[EC2InstanceID] = scala
      .Option(impl.ec2InstanceID())
      .map(value => zio.aws.mgn.model.primitives.EC2InstanceID(value))
    override val firstBoot: Option[zio.aws.mgn.model.FirstBoot] = scala
      .Option(impl.firstBoot())
      .map(value => zio.aws.mgn.model.FirstBoot.wrap(value))
    override val jobID: Option[JobID] = scala
      .Option(impl.jobID())
      .map(value => zio.aws.mgn.model.primitives.JobID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LaunchedInstance
  ): zio.aws.mgn.model.LaunchedInstance.ReadOnly = new Wrapper(impl)
}
