package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  JobID,
  TagValue,
  ISO8601DatetimeString,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class Job(
    arn: Option[ARN] = None,
    creationDateTime: Option[ISO8601DatetimeString] = None,
    endDateTime: Option[ISO8601DatetimeString] = None,
    initiatedBy: Option[zio.aws.mgn.model.InitiatedBy] = None,
    jobID: JobID,
    participatingServers: Option[
      Iterable[zio.aws.mgn.model.ParticipatingServer]
    ] = None,
    status: Option[zio.aws.mgn.model.JobStatus] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    `type`: Option[zio.aws.mgn.model.JobType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.Job
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        creationDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.creationDateTime)
      .optionallyWith(
        endDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.endDateTime)
      .optionallyWith(initiatedBy.map(value => value.unwrap))(_.initiatedBy)
      .jobID(JobID.unwrap(jobID): java.lang.String)
      .optionallyWith(
        participatingServers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.participatingServers)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.Job.ReadOnly =
    zio.aws.mgn.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.Job = zio.aws.mgn.model.Job(
      arn.map(value => value),
      creationDateTime.map(value => value),
      endDateTime.map(value => value),
      initiatedBy.map(value => value),
      jobID,
      participatingServers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      status.map(value => value),
      tags.map(value => value),
      `type`.map(value => value)
    )
    def arn: Option[ARN]
    def creationDateTime: Option[ISO8601DatetimeString]
    def endDateTime: Option[ISO8601DatetimeString]
    def initiatedBy: Option[zio.aws.mgn.model.InitiatedBy]
    def jobID: JobID
    def participatingServers
        : Option[List[zio.aws.mgn.model.ParticipatingServer.ReadOnly]]
    def status: Option[zio.aws.mgn.model.JobStatus]
    def tags: Option[Map[TagKey, TagValue]]
    def `type`: Option[zio.aws.mgn.model.JobType]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getCreationDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getEndDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
    def getInitiatedBy: ZIO[Any, AwsError, zio.aws.mgn.model.InitiatedBy] =
      AwsError.unwrapOptionField("initiatedBy", initiatedBy)
    def getJobID: ZIO[Any, Nothing, JobID] = ZIO.succeed(jobID)
    def getParticipatingServers: ZIO[Any, AwsError, List[
      zio.aws.mgn.model.ParticipatingServer.ReadOnly
    ]] =
      AwsError.unwrapOptionField("participatingServers", participatingServers)
    def getStatus: ZIO[Any, AwsError, zio.aws.mgn.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.mgn.model.JobType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.Job
  ) extends zio.aws.mgn.model.Job.ReadOnly {
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val creationDateTime: Option[ISO8601DatetimeString] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val endDateTime: Option[ISO8601DatetimeString] = scala
      .Option(impl.endDateTime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val initiatedBy: Option[zio.aws.mgn.model.InitiatedBy] = scala
      .Option(impl.initiatedBy())
      .map(value => zio.aws.mgn.model.InitiatedBy.wrap(value))
    override val jobID: JobID = zio.aws.mgn.model.primitives.JobID(impl.jobID())
    override val participatingServers
        : Option[List[zio.aws.mgn.model.ParticipatingServer.ReadOnly]] = scala
      .Option(impl.participatingServers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.ParticipatingServer.wrap(item)
        }.toList
      )
    override val status: Option[zio.aws.mgn.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.mgn.model.JobStatus.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Option[zio.aws.mgn.model.JobType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.mgn.model.JobType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.Job
  ): zio.aws.mgn.model.Job.ReadOnly = new Wrapper(impl)
}
