package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class FinalizeCutoverRequest(sourceServerID: SourceServerID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest = {
    import FinalizeCutoverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest
      .builder()
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.FinalizeCutoverRequest.ReadOnly =
    zio.aws.mgn.model.FinalizeCutoverRequest.wrap(buildAwsValue())
}
object FinalizeCutoverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.FinalizeCutoverRequest =
      zio.aws.mgn.model.FinalizeCutoverRequest(sourceServerID)
    def sourceServerID: SourceServerID
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest
  ) extends zio.aws.mgn.model.FinalizeCutoverRequest.ReadOnly {
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest
  ): zio.aws.mgn.model.FinalizeCutoverRequest.ReadOnly = new Wrapper(impl)
}
